"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _esQuery = require("@kbn/es-query");
var _helpers = require("../../../../common/components/threat_match/helpers");
var _utils = require("../../../../../common/detection_engine/utils");
var _constants = require("../../../../../common/constants");
var _helpers2 = require("../../../../../common/machine_learning/helpers");
var _shared_imports = require("../../../../shared_imports");
var _types = require("../../../pages/detection_engine/rules/types");
var _validators = require("../eql_query_bar/validators");
var _esql_validator = require("../../../../detection_engine/rule_creation/logic/esql_validator");
var _translations = require("./translations");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const schema = {
  index: {
    defaultValue: [],
    fieldsToValidateOnChange: ['index', 'queryBar'],
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fiedIndexPatternsLabel', {
      defaultMessage: 'Index patterns'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _translations.INDEX_HELPER_TEXT),
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        const skipValidation = (0, _helpers2.isMlRule)(formData.ruleType) || (0, _utils.isEsqlRule)(formData.ruleType) || formData.dataSourceType !== _types.DataSourceType.IndexPatterns;
        if (skipValidation) {
          return;
        }
        return _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.outputIndiceNameFieldRequiredError', {
          defaultMessage: 'A minimum of one index pattern is required.'
        }))(...args);
      }
    }]
  },
  dataViewId: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.dataViewSelector', {
      defaultMessage: 'Data view'
    }),
    fieldsToValidateOnChange: ['dataViewId'],
    validations: [{
      validator: (...args) => {
        const [{
          path,
          formData
        }] = args;
        // the dropdown defaults the dataViewId to an empty string somehow on render..
        // need to figure this out.
        const notEmptyDataViewId = formData.dataViewId != null && formData.dataViewId !== '';
        const skipValidation = (0, _helpers2.isMlRule)(formData.ruleType) || notEmptyDataViewId || formData.dataSourceType !== _types.DataSourceType.DataView;
        if (skipValidation) {
          return;
        }
        return {
          path,
          message: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.dataViewSelectorFieldRequired', {
            defaultMessage: 'Please select an available Data View or Index Pattern.'
          })
        };
      }
    }]
  },
  dataViewTitle: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.dataViewTitleSelector', {
      defaultMessage: 'Data view index pattern'
    }),
    validations: []
  },
  eqlOptions: {},
  queryBar: {
    fieldsToValidateOnChange: ['queryBar'],
    validations: [{
      validator: (...args) => {
        const [{
          value,
          path,
          formData
        }] = args;
        const {
          query,
          filters,
          saved_id: savedId
        } = value;
        const needsValidation = !(0, _helpers2.isMlRule)(formData.ruleType);
        if (!needsValidation) {
          return undefined;
        }
        const isFieldEmpty = (0, _lodash.isEmpty)(query.query) && (0, _lodash.isEmpty)(filters);
        if (!isFieldEmpty) {
          return undefined;
        }
        if (savedId) {
          // Ignore field validation error in this case.
          // Instead, we show the error toast when saved query object does not exist.
          // https://github.com/elastic/kibana/issues/159060
          return undefined;
        }
        const message = (0, _utils2.getQueryRequiredMessage)(formData.ruleType);
        return {
          code: 'ERR_FIELD_MISSING',
          path,
          message
        };
      }
    }, {
      validator: (...args) => {
        const [{
          value,
          path,
          formData
        }] = args;
        const {
          query
        } = value;
        const needsValidation = !(0, _helpers2.isMlRule)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        if (!(0, _lodash.isEmpty)(query.query) && query.language === 'kuery') {
          try {
            (0, _esQuery.fromKueryExpression)(query.query);
          } catch (err) {
            return {
              code: 'ERR_FIELD_FORMAT',
              path,
              message: _translations.INVALID_CUSTOM_QUERY
            };
          }
        }
      }
    }, {
      validator: (0, _validators.debounceAsync)(_validators.eqlValidator, 300)
    }, {
      validator: (0, _validators.debounceAsync)(_esql_validator.esqlValidator, 300)
    }]
  },
  ruleType: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldRuleTypeLabel', {
      defaultMessage: 'Rule type'
    }),
    validations: []
  },
  anomalyThreshold: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldAnomalyThresholdLabel', {
      defaultMessage: 'Anomaly score threshold'
    }),
    validations: []
  },
  machineLearningJobId: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldMachineLearningJobIdLabel', {
      defaultMessage: 'Machine Learning job'
    }),
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        const needsValidation = (0, _helpers2.isMlRule)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        return _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.machineLearningJobIdRequired', {
          defaultMessage: 'A Machine Learning job is required.'
        }))(...args);
      }
    }]
  },
  relatedIntegrations: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRelatedIntegrationsLabel', {
      defaultMessage: 'Related integrations'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRelatedIntegrationsHelpText', {
      defaultMessage: 'Integration related to this Rule.'
    })
  },
  requiredFields: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRequiredFieldsLabel', {
      defaultMessage: 'Required fields'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRequiredFieldsHelpText', {
      defaultMessage: 'Fields required for this Rule to function.'
    })
  },
  timeline: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTimelineTemplateLabel', {
      defaultMessage: 'Timeline template'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTimelineTemplateHelpText', {
      defaultMessage: 'Select which timeline to use when investigating generated alerts.'
    })
  },
  threshold: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldThresholdLabel', {
      defaultMessage: 'Threshold'
    }),
    field: {
      type: _shared_imports.FIELD_TYPES.COMBO_BOX,
      label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldThresholdFieldLabel', {
        defaultMessage: 'Group by'
      }),
      helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldThresholdFieldHelpText', {
        defaultMessage: "Select fields to group by. Fields are joined together with 'AND'"
      }),
      validations: [{
        validator: (...args) => {
          const [{
            formData
          }] = args;
          const needsValidation = (0, _utils.isThresholdRule)(formData.ruleType);
          if (!needsValidation) {
            return;
          }
          return _shared_imports.fieldValidators.maxLengthField({
            length: 3,
            message: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.thresholdFieldFieldData.arrayLengthGreaterThanMaxErrorMessage', {
              defaultMessage: 'Number of fields must be 3 or less.'
            })
          })(...args);
        }
      }]
    },
    value: {
      type: _shared_imports.FIELD_TYPES.NUMBER,
      label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldThresholdValueLabel', {
        defaultMessage: 'Threshold'
      }),
      validations: [{
        validator: (...args) => {
          const [{
            formData
          }] = args;
          const needsValidation = (0, _utils.isThresholdRule)(formData.ruleType);
          if (!needsValidation) {
            return;
          }
          return _shared_imports.fieldValidators.numberGreaterThanField({
            than: 1,
            message: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.thresholdValueFieldData.numberGreaterThanOrEqualOneErrorMessage', {
              defaultMessage: 'Value must be greater than or equal to one.'
            }),
            allowEquality: true
          })(...args);
        }
      }]
    },
    cardinality: {
      field: {
        defaultValue: [],
        fieldsToValidateOnChange: ['threshold.cardinality.field', 'threshold.cardinality.value'],
        type: _shared_imports.FIELD_TYPES.COMBO_BOX,
        label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldThresholdCardinalityFieldLabel', {
          defaultMessage: 'Count'
        }),
        validations: [{
          validator: (...args) => {
            const [{
              formData
            }] = args;
            const needsValidation = (0, _utils.isThresholdRule)(formData.ruleType);
            if (!needsValidation) {
              return;
            }
            if ((0, _lodash.isEmpty)(formData['threshold.cardinality.field']) && !(0, _lodash.isEmpty)(formData['threshold.cardinality.value'])) {
              return _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.thresholdCardinalityFieldFieldData.thresholdCardinalityFieldNotSuppliedMessage', {
                defaultMessage: 'A Cardinality Field is required.'
              }))(...args);
            }
          }
        }],
        helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldThresholdFieldCardinalityFieldHelpText', {
          defaultMessage: 'Select a field to check cardinality'
        })
      },
      value: {
        fieldsToValidateOnChange: ['threshold.cardinality.field', 'threshold.cardinality.value'],
        type: _shared_imports.FIELD_TYPES.NUMBER,
        label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldThresholdCardinalityValueFieldLabel', {
          defaultMessage: 'Unique values'
        }),
        validations: [{
          validator: (...args) => {
            const [{
              formData
            }] = args;
            const needsValidation = (0, _utils.isThresholdRule)(formData.ruleType);
            if (!needsValidation) {
              return;
            }
            if (!(0, _lodash.isEmpty)(formData['threshold.cardinality.field'])) {
              return _shared_imports.fieldValidators.numberGreaterThanField({
                than: 1,
                message: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.thresholdCardinalityValueFieldData.numberGreaterThanOrEqualOneErrorMessage', {
                  defaultMessage: 'Value must be greater than or equal to one.'
                }),
                allowEquality: true
              })(...args);
            }
          }
        }]
      }
    }
  },
  threatIndex: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldThreatIndexPatternsLabel', {
      defaultMessage: 'Indicator index patterns'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _translations.THREAT_MATCH_INDEX_HELPER_TEXT),
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        const needsValidation = (0, _utils.isThreatMatchRule)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        return _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.threatMatchoutputIndiceNameFieldRequiredError', {
          defaultMessage: 'A minimum of one index pattern is required.'
        }))(...args);
      }
    }, {
      validator: (...args) => {
        const [{
          formData,
          value
        }] = args;
        const needsValidation = (0, _utils.isThreatMatchRule)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        return _helpers.customValidators.forbiddenField(value, '*');
      }
    }]
  },
  threatMapping: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldThreatMappingLabel', {
      defaultMessage: 'Indicator mapping'
    }),
    validations: [{
      validator: (...args) => {
        const [{
          path,
          formData
        }] = args;
        const needsValidation = (0, _utils.isThreatMatchRule)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        if ((0, _helpers.singleEntryThreat)(formData.threatMapping)) {
          return {
            code: 'ERR_FIELD_MISSING',
            path,
            message: _translations.THREAT_MATCH_REQUIRED
          };
        } else if ((0, _helpers.containsInvalidItems)(formData.threatMapping)) {
          return {
            code: 'ERR_FIELD_MISSING',
            path,
            message: _translations.THREAT_MATCH_EMPTIES
          };
        } else {
          return undefined;
        }
      }
    }]
  },
  threatQueryBar: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldThreatQueryBarLabel', {
      defaultMessage: 'Indicator index query'
    }),
    validations: [{
      validator: (...args) => {
        const [{
          value,
          path,
          formData
        }] = args;
        const needsValidation = (0, _utils.isThreatMatchRule)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        const {
          query,
          filters
        } = value;
        return (0, _lodash.isEmpty)(query.query) && (0, _lodash.isEmpty)(filters) ? {
          code: 'ERR_FIELD_MISSING',
          path,
          message: _translations.CUSTOM_QUERY_REQUIRED
        } : undefined;
      }
    }, {
      validator: (...args) => {
        const [{
          value,
          path,
          formData
        }] = args;
        const needsValidation = (0, _utils.isThreatMatchRule)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        const {
          query
        } = value;
        if (!(0, _lodash.isEmpty)(query.query) && query.language === 'kuery') {
          try {
            (0, _esQuery.fromKueryExpression)(query.query);
          } catch (err) {
            return {
              code: 'ERR_FIELD_FORMAT',
              path,
              message: _translations.INVALID_CUSTOM_QUERY
            };
          }
        }
      }
    }]
  },
  groupByFields: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.groupByFieldsLabel', {
      defaultMessage: 'Suppress alerts by'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.groupByFieldsLabelAppend', {
      defaultMessage: 'Optional (Technical Preview)'
    })),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldGroupByFieldHelpText', {
      defaultMessage: 'Select field(s) to use for suppressing extra alerts'
    }),
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        const needsValidation = (0, _utils.isQueryRule)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        return _shared_imports.fieldValidators.maxLengthField({
          length: 3,
          message: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.stepDefineRule.groupByFieldsMax', {
            defaultMessage: 'Number of grouping fields must be at most 3'
          })
        })(...args);
      }
    }]
  },
  groupByRadioSelection: {},
  groupByDuration: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.groupByDurationValueLabel', {
      defaultMessage: 'Suppress alerts for'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldGroupByDurationValueHelpText', {
      defaultMessage: 'Suppress alerts for'
    }),
    value: {},
    unit: {}
  },
  suppressionMissingFields: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.suppressionMissingFieldsLabel', {
      defaultMessage: 'If a suppression field is missing'
    })
  },
  newTermsFields: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.newTermsFieldsLabel', {
      defaultMessage: 'Fields'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldNewTermsFieldHelpText', {
      defaultMessage: 'Select a field to check for new terms.'
    }),
    validations: [{
      validator: (...args) => {
        const [{
          formData
        }] = args;
        const needsValidation = (0, _utils.isNewTermsRule)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        return _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.newTermsFieldsMin', {
          defaultMessage: 'A minimum of one field is required.'
        }))(...args);
      }
    }, {
      validator: (...args) => {
        const [{
          formData
        }] = args;
        const needsValidation = (0, _utils.isNewTermsRule)(formData.ruleType);
        if (!needsValidation) {
          return;
        }
        return _shared_imports.fieldValidators.maxLengthField({
          length: _constants.MAX_NUMBER_OF_NEW_TERMS_FIELDS,
          message: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.stepDefineRule.newTermsFieldsMax', {
            defaultMessage: 'Number of fields must be 3 or less.'
          })
        })(...args);
      }
    }]
  },
  historyWindowSize: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.historyWindowSizeLabel', {
      defaultMessage: 'History Window Size'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepScheduleRule.historyWindowSizeHelpText', {
      defaultMessage: "New terms rules only alert if terms don't appear in historical data."
    })
  },
  shouldLoadQueryDynamically: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    defaultValue: false
  },
  enableThresholdSuppression: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    defaultValue: false
  }
};
exports.schema = schema;