"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatMatchAboutSchema = exports.schema = void 0;
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../shared_imports");
var _optional_field_label = require("../optional_field_label");
var _validators = require("../../../../common/utils/validators");
var I18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const schema = {
  author: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldAuthorLabel', {
      defaultMessage: 'Author'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldAuthorHelpText', {
      defaultMessage: 'Type one or more authors for this rule. Press enter after each author to add a new one.'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel,
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.authorFieldEmptyError', {
        defaultMessage: 'An author must not be empty'
      })),
      type: _shared_imports.VALIDATION_TYPES.ARRAY_ITEM,
      isBlocking: false
    }]
  },
  name: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldNameLabel', {
      defaultMessage: 'Name'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.nameFieldRequiredError', {
        defaultMessage: 'A name is required.'
      }))
    }]
  },
  description: {
    type: _shared_imports.FIELD_TYPES.TEXTAREA,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldDescriptionLabel', {
      defaultMessage: 'Description'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.descriptionFieldRequiredError', {
        defaultMessage: 'A description is required.'
      }))
    }]
  },
  isBuildingBlock: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldBuildingBlockLabel', {
      defaultMessage: 'Mark all generated alerts as "building block" alerts'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  isAssociatedToEndpointList: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldAssociatedToEndpointListLabel', {
      defaultMessage: 'Add existing Endpoint exceptions to the rule'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  severity: {
    value: {},
    mapping: {},
    isMappingChecked: {}
  },
  riskScore: {
    value: {},
    mapping: {},
    isMappingChecked: {}
  },
  references: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldReferenceUrlsLabel', {
      defaultMessage: 'Reference URLs'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel,
    validations: [{
      validator: (...args) => {
        const [{
          value,
          path
        }] = args;
        let hasError = false;
        value.forEach(url => {
          if ((0, _validators.isUrlInvalid)(url)) {
            hasError = true;
          }
        });
        return hasError ? {
          code: 'ERR_FIELD_FORMAT',
          path,
          message: I18n.URL_FORMAT_INVALID
        } : undefined;
      }
    }]
  },
  falsePositives: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldFalsePositiveLabel', {
      defaultMessage: 'False positive examples'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  investigationFields: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldCustomHighlightedFieldsLabel', {
      defaultMessage: 'Custom highlighted fields'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  license: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldLicenseLabel', {
      defaultMessage: 'License'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldLicenseHelpText', {
      defaultMessage: 'Add a license name'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  ruleNameOverride: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRuleNameOverrideLabel', {
      defaultMessage: 'Rule name override'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldRuleNameOverrideHelpText', {
      defaultMessage: 'Choose a field from the source event to populate the rule name in the alert list.'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  threat: {
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldMitreThreatLabel', {
      defaultMessage: 'MITRE ATT&CK\\u2122'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  threatIndicatorPath: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldThreatIndicatorPathLabel', {
      defaultMessage: 'Indicator prefix override'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldThreatIndicatorPathHelpText', {
      defaultMessage: 'Specify the document prefix containing your indicator fields. Used for enrichment of indicator match alerts.'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  timestampOverride: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTimestampOverrideLabel', {
      defaultMessage: 'Timestamp override'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTimestampOverrideHelpText', {
      defaultMessage: 'Choose timestamp field used when executing rule. Pick field with timestamp closest to ingest time (e.g. event.ingested).'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  timestampOverrideFallbackDisabled: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    defaultValue: false,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTimestampOverrideFallbackDisabledLabel', {
      defaultMessage: 'Do not use @timestamp as a fallback timestamp field'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  },
  tags: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTagsLabel', {
      defaultMessage: 'Tags'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldTagsHelpText', {
      defaultMessage: 'Type one or more custom identifying tags for this rule. Press enter after each tag to begin a new one.'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel,
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.tagFieldEmptyError', {
        defaultMessage: 'A tag must not be empty'
      })),
      type: _shared_imports.VALIDATION_TYPES.ARRAY_ITEM,
      isBlocking: false
    }]
  },
  note: {
    type: _shared_imports.FIELD_TYPES.TEXTAREA,
    label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.guideLabel', {
      defaultMessage: 'Investigation guide'
    }),
    helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.guideHelpText', {
      defaultMessage: 'Provide helpful information for analysts that are investigating detection alerts. This guide will appear on the rule details page and in timelines (as notes) created from detection alerts generated by this rule.'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel
  }
};
exports.schema = schema;
const threatIndicatorPathRequiredSchemaValue = {
  type: _shared_imports.FIELD_TYPES.TEXT,
  label: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldThreatIndicatorPathLabel', {
    defaultMessage: 'Indicator prefix override'
  }),
  helpText: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldThreatIndicatorPathHelpText', {
    defaultMessage: 'Specify the document prefix containing your indicator fields. Used for enrichment of indicator match alerts.'
  }),
  validations: [{
    validator: emptyField(_i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.threatIndicatorPathFieldEmptyError', {
      defaultMessage: 'Indicator prefix override must not be empty'
    })),
    type: _shared_imports.VALIDATION_TYPES.FIELD
  }]
};
const threatMatchAboutSchema = {
  ...schema,
  threatIndicatorPath: threatIndicatorPathRequiredSchemaValue
};
exports.threatMatchAboutSchema = threatMatchAboutSchema;