"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlUserJobDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _noop = _interopRequireDefault(require("lodash/noop"));
var i18n = _interopRequireWildcard(require("../translations"));
var _helpers = require("../../../../../../common/machine_learning/helpers");
var _ml_job_item = require("../ml_job_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlUserJobDescriptionComponent = ({
  job
}) => {
  const switchComponent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.ML_ADMIN_REQUIRED
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: true,
    "data-test-subj": "mlUserJobSwitch",
    showLabel: false,
    label: "",
    checked: (0, _helpers.isJobStarted)(job.jobState, job.datafeedState),
    onChange: _noop.default
  })), [job]);
  return /*#__PURE__*/_react.default.createElement(_ml_job_item.MlJobItem, {
    job: job,
    switchComponent: switchComponent
  });
};
const MlUserJobDescription = /*#__PURE__*/(0, _react.memo)(MlUserJobDescriptionComponent);
exports.MlUserJobDescription = MlUserJobDescription;