"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMitreAttackThreat = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var Rulei18n = _interopRequireWildcard(require("../../../pages/detection_engine/rules/translations"));
var _default_value = require("../step_about_rule/default_value");
var _add_item_form = require("../add_item_form");
var i18n = _interopRequireWildcard(require("./translations"));
var _technique_fields = require("./technique_fields");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const lazyMitreConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_mitre_configuration" */
  '../../../mitre/mitre_tactics_techniques')));
};
const MitreAttackContainer = _styledComponents.default.div`
  margin-top: 16px;
`;
const InitialMitreAttackFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  .euiFormRow__labelWrapper {
    .euiText {
      padding-right: 32px;
    }
  }
`;
// eslint-disable-next-line react/display-name
const AddMitreAttackThreat = /*#__PURE__*/(0, _react.memo)(({
  field,
  idAria,
  isDisabled
}) => {
  const removeTactic = (0, _react.useCallback)(index => {
    const values = [...field.value];
    values.splice(index, 1);
    if ((0, _fp.isEmpty)(values)) {
      field.setValue(_default_value.threatDefault);
    } else {
      field.setValue(values);
    }
  }, [field]);
  const addMitreAttackTactic = (0, _react.useCallback)(() => {
    const values = [...field.value];
    if (!(0, _fp.isEmpty)(values[values.length - 1])) {
      field.setValue([...values, {
        tactic: {
          id: 'none',
          name: 'none',
          reference: 'none'
        },
        technique: []
      }]);
    } else {
      field.setValue([{
        tactic: {
          id: 'none',
          name: 'none',
          reference: 'none'
        },
        technique: []
      }]);
    }
  }, [field]);
  const [tacticsOptions, setTacticsOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    async function getMitre() {
      const mitreConfig = await lazyMitreConfiguration();
      setTacticsOptions(mitreConfig.tactics);
    }
    getMitre();
  }, []);
  const updateTactic = (0, _react.useCallback)((index, value) => {
    const values = [...field.value];
    const {
      id,
      reference,
      name
    } = tacticsOptions.find(t => t.value === value) || {
      id: '',
      name: '',
      reference: ''
    };
    values.splice(index, 1, {
      ...values[index],
      tactic: {
        id,
        reference,
        name
      },
      technique: []
    });
    field.setValue([...values]);
  }, [field, tacticsOptions]);
  const values = (0, _react.useMemo)(() => {
    return [...field.value];
  }, [field]);
  const getSelectTactic = (0, _react.useCallback)((threat, index, disabled) => {
    const tacticName = threat.tactic.name;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      id: "mitreAttackTactic",
      options: [...(tacticName === 'none' ? [{
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.TACTIC_PLACEHOLDER),
        value: 'none',
        disabled
      }] : []), ...tacticsOptions.map(t => ({
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, t.label),
        value: t.value,
        disabled
      }))],
      prepend: `${field.label} ${i18n.TACTIC}`,
      "aria-label": "",
      onChange: updateTactic.bind(null, index),
      fullWidth: true,
      valueOfSelected: (0, _fp.camelCase)(tacticName),
      "data-test-subj": "mitreAttackTactic",
      placeholder: i18n.TACTIC_PLACEHOLDER
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "danger",
      iconType: "trash",
      isDisabled: isDisabled || (0, _lodash.isEqual)(values, _default_value.threatDefault),
      onClick: () => removeTactic(index),
      "aria-label": Rulei18n.DELETE
    })));
  }, [field.label, isDisabled, removeTactic, tacticsOptions, updateTactic, values]);

  /**
   * Uses the fieldhook to set a new field value
   *
   * Value is memoized on top level props, any deep changes will have to be new objects
   */
  const onFieldChange = (0, _react.useCallback)(threats => {
    field.setValue(threats);
  }, [field]);
  return /*#__PURE__*/_react.default.createElement(MitreAttackContainer, null, values.map((threat, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index
  }, index === 0 ? /*#__PURE__*/_react.default.createElement(InitialMitreAttackFormRow, {
    fullWidth: true,
    label: `${field.label} ${i18n.THREATS}`,
    labelAppend: field.labelAppend,
    describedByIds: idAria ? [`${idAria} ${i18n.TACTIC}`] : undefined
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getSelectTactic(threat, index, isDisabled))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    describedByIds: idAria ? [`${idAria} ${i18n.TACTIC}`] : undefined
  }, getSelectTactic(threat, index, isDisabled)), /*#__PURE__*/_react.default.createElement(_technique_fields.MitreAttackTechniqueFields, {
    field: field,
    threatIndex: index,
    isDisabled: isDisabled || threat.tactic.name === 'none',
    idAria: idAria,
    onFieldChange: onFieldChange
  }))), /*#__PURE__*/_react.default.createElement(_add_item_form.MyAddItemButton, {
    "data-test-subj": "addMitreAttackTactic",
    onClick: addMitreAttackTactic,
    isDisabled: isDisabled
  }, i18n.ADD_MITRE_TACTIC));
});
exports.AddMitreAttackThreat = AddMitreAttackThreat;