"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSuppressionTechnicalPreviewBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _technical_preview_badge = require("../technical_preview_badge");
var _use_upselling = require("../../../../common/hooks/use_upselling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSuppressionTechnicalPreviewBadge = ({
  label
}) => {
  const alertSuppressionUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('alert_suppression_rule_details');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    label: label
  }), alertSuppressionUpsellingMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: alertSuppressionUpsellingMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'warning',
    size: "l",
    color: "#BD271E",
    style: {
      marginLeft: '8px'
    }
  })));
};
exports.AlertSuppressionTechnicalPreviewBadge = AlertSuppressionTechnicalPreviewBadge;