"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IsolateHost = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_host_isolation = require("../../containers/detection_engine/alerts/use_host_isolation");
var _translations = require("./translations");
var _host_isolation = require("../../../common/components/endpoint/host_isolation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IsolateHost = /*#__PURE__*/_react.default.memo(({
  endpointId,
  hostName,
  casesInfo,
  cancelCallback,
  successCallback
}) => {
  const [comment, setComment] = (0, _react.useState)('');
  const [isIsolated, setIsIsolated] = (0, _react.useState)(false);
  const caseIds = casesInfo.map(caseInfo => {
    return caseInfo.id;
  });
  const {
    loading,
    isolateHost
  } = (0, _use_host_isolation.useHostIsolation)({
    endpointId,
    comment,
    caseIds
  });
  const confirmHostIsolation = (0, _react.useCallback)(async () => {
    const hostIsolated = await isolateHost();
    setIsIsolated(hostIsolated);
    if (hostIsolated && successCallback) {
      successCallback();
    }
  }, [isolateHost, successCallback]);
  const backToAlertDetails = (0, _react.useCallback)(() => cancelCallback(), [cancelCallback]);
  const handleIsolateFormChange = (0, _react.useCallback)(({
    comment: newComment
  }) => setComment(newComment), []);
  const caseCount = (0, _react.useMemo)(() => casesInfo.length, [casesInfo]);
  const hostIsolatedSuccessButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_host_isolation.ActionCompletionReturnButton, {
      onClick: backToAlertDetails,
      buttonText: _translations.RETURN_TO_ALERT_DETAILS
    });
  }, [backToAlertDetails]);
  const hostNotIsolated = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_host_isolation.EndpointIsolateForm, {
      hostName: hostName,
      onCancel: backToAlertDetails,
      onConfirm: confirmHostIsolation,
      onChange: handleIsolateFormChange,
      comment: comment,
      isLoading: loading,
      messageAppend: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detections.hostIsolation.impactedCases",
        defaultMessage: "This action will be added to {cases}.",
        values: {
          cases: /*#__PURE__*/_react.default.createElement("b", null, (0, _translations.CASES_ASSOCIATED_WITH_ALERT)(caseCount))
        }
      })
    }));
  }, [hostName, backToAlertDetails, confirmHostIsolation, handleIsolateFormChange, comment, loading, caseCount]);
  return isIsolated ? hostIsolatedSuccessButton : hostNotIsolated;
});
exports.IsolateHost = IsolateHost;
IsolateHost.displayName = 'IsolateHost';