"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingPrivilegesCallOut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _objectHash = _interopRequireDefault(require("object-hash"));
var _callouts = require("../../../../common/components/callouts");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_missing_privileges = require("./use_missing_privileges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MissingPrivilegesCallOutComponent = () => {
  const missingPrivileges = (0, _use_missing_privileges.useMissingPrivileges)();
  const MissingPrivilegesMessage = (0, _react.useMemo)(() => {
    const hasMissingPrivileges = missingPrivileges.indexPrivileges.length > 0 || missingPrivileges.featurePrivileges.length > 0;
    if (!hasMissingPrivileges) {
      return null;
    }
    const missingPrivilegesHash = (0, _objectHash.default)(missingPrivileges);
    return {
      type: 'primary',
      /**
       * Use privileges hash as a part of the message id.
       * We want to make sure that the user will see the
       * callout message in case his privileges change.
       * The previous click on Dismiss should not affect that.
       */
      id: `missing-user-privileges-${missingPrivilegesHash}`,
      title: i18n.MISSING_PRIVILEGES_CALLOUT_TITLE,
      description: i18n.missingPrivilegesCallOutBody(missingPrivileges)
    };
  }, [missingPrivileges]);
  return MissingPrivilegesMessage && /*#__PURE__*/_react.default.createElement(_callouts.CallOutSwitcher, {
    namespace: "detections",
    condition: true,
    message: MissingPrivilegesMessage
  });
};
const MissingPrivilegesCallOut = /*#__PURE__*/(0, _react.memo)(MissingPrivilegesCallOutComponent);
exports.MissingPrivilegesCallOut = MissingPrivilegesCallOut;