"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToCaseActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/cases-plugin/common");
var _common2 = require("../../../../../common");
var _cases_tour_steps = require("../../../../common/components/guided_onboarding_tour/cases_tour_steps");
var _tour_config = require("../../../../common/components/guided_onboarding_tour/tour_config");
var _guided_onboarding_tour = require("../../../../common/components/guided_onboarding_tour");
var _kibana = require("../../../../common/lib/kibana");
var _translations = require("../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddToCaseActions = ({
  onMenuItemClick,
  ariaLabel,
  ecsData,
  nonEcsData,
  onSuccess,
  isActiveTimelines,
  isInDetections,
  refetch
}) => {
  const {
    cases: casesUi
  } = (0, _kibana.useKibana)().services;
  const userCasesPermissions = casesUi.helpers.canUseCases([_common2.APP_ID]);
  const isAlert = (0, _react.useMemo)(() => {
    var _ecsData$event, _ecsData$event$kind;
    return ecsData === null || ecsData === void 0 ? void 0 : (_ecsData$event = ecsData.event) === null || _ecsData$event === void 0 ? void 0 : (_ecsData$event$kind = _ecsData$event.kind) === null || _ecsData$event$kind === void 0 ? void 0 : _ecsData$event$kind.includes('signal');
  }, [ecsData]);
  const caseAttachments = (0, _react.useMemo)(() => {
    var _ecsData$_id, _ecsData$_index;
    return ecsData !== null && ecsData !== void 0 && ecsData._id ? [{
      alertId: (_ecsData$_id = ecsData === null || ecsData === void 0 ? void 0 : ecsData._id) !== null && _ecsData$_id !== void 0 ? _ecsData$_id : '',
      index: (_ecsData$_index = ecsData === null || ecsData === void 0 ? void 0 : ecsData._index) !== null && _ecsData$_index !== void 0 ? _ecsData$_index : '',
      type: _common.AttachmentType.alert,
      rule: casesUi.helpers.getRuleIdFromEvent({
        ecs: ecsData,
        data: nonEcsData !== null && nonEcsData !== void 0 ? nonEcsData : []
      })
    }] : [];
  }, [casesUi.helpers, ecsData, nonEcsData]);
  const {
    activeStep,
    incrementStep,
    setStep,
    isTourShown
  } = (0, _guided_onboarding_tour.useTourContext)();
  const onCaseSuccess = () => {
    if (onSuccess) {
      onSuccess();
    }
    if (refetch) {
      refetch();
    }
  };
  const afterCaseCreated = (0, _react.useCallback)(async () => {
    if (isTourShown(_tour_config.SecurityStepId.alertsCases)) {
      setStep(_tour_config.SecurityStepId.alertsCases, _tour_config.AlertsCasesTourSteps.viewCase);
    }
  }, [setStep, isTourShown]);
  const prefillCasesValue = (0, _react.useMemo)(() => isTourShown(_tour_config.SecurityStepId.alertsCases) && (activeStep === _tour_config.AlertsCasesTourSteps.addAlertToCase || activeStep === _tour_config.AlertsCasesTourSteps.createCase || activeStep === _tour_config.AlertsCasesTourSteps.submitCase) ? {
    initialValue: _tour_config.sampleCase
  } : {}, [activeStep, isTourShown]);
  const createCaseFlyout = casesUi.hooks.useCasesAddToNewCaseFlyout({
    onClose: onMenuItemClick,
    onSuccess: onCaseSuccess,
    afterCaseCreated,
    ...prefillCasesValue
  });
  const selectCaseModal = casesUi.hooks.useCasesAddToExistingCaseModal({
    onClose: onMenuItemClick,
    onSuccess: onCaseSuccess
  });
  const handleAddToNewCaseClick = (0, _react.useCallback)(() => {
    // TODO rename this, this is really `closePopover()`
    onMenuItemClick();
    createCaseFlyout.open({
      attachments: caseAttachments,
      // activeStep will be AlertsCasesTourSteps.addAlertToCase on first render because not yet incremented
      // if the user closes the flyout without completing the form and comes back, we will be at step AlertsCasesTourSteps.createCase
      ...(isTourShown(_tour_config.SecurityStepId.alertsCases) ? {
        headerContent: /*#__PURE__*/_react.default.createElement(_cases_tour_steps.CasesTourSteps, null)
      } : {})
    });
    if (isTourShown(_tour_config.SecurityStepId.alertsCases) && activeStep === _tour_config.AlertsCasesTourSteps.addAlertToCase) {
      incrementStep(_tour_config.SecurityStepId.alertsCases);
    }
  }, [onMenuItemClick, createCaseFlyout, caseAttachments, isTourShown, activeStep, incrementStep]);
  const handleAddToExistingCaseClick = (0, _react.useCallback)(() => {
    // TODO rename this, this is really `closePopover()`
    onMenuItemClick();
    selectCaseModal.open({
      getAttachments: () => caseAttachments
    });
  }, [caseAttachments, onMenuItemClick, selectCaseModal]);
  const addToCaseActionItems = (0, _react.useMemo)(() => {
    if ((isActiveTimelines || isInDetections) && userCasesPermissions.create && userCasesPermissions.read && isAlert) {
      return [
      // add to existing case menu item
      {
        'aria-label': ariaLabel,
        'data-test-subj': 'add-to-existing-case-action',
        key: 'add-to-existing-case-action',
        onClick: handleAddToExistingCaseClick,
        size: 's',
        name: _translations.ADD_TO_EXISTING_CASE
      },
      // add to new case menu item
      {
        'aria-label': ariaLabel,
        'data-test-subj': 'add-to-new-case-action',
        key: 'add-to-new-case-action',
        onClick: handleAddToNewCaseClick,
        size: 's',
        name: _translations.ADD_TO_NEW_CASE
      }];
    }
    return [];
  }, [ariaLabel, handleAddToExistingCaseClick, handleAddToNewCaseClick, userCasesPermissions.create, userCasesPermissions.read, isInDetections, isActiveTimelines, isAlert]);
  return {
    addToCaseActionItems,
    handleAddToNewCaseClick,
    handleAddToExistingCaseClick
  };
};
exports.useAddToCaseActions = useAddToCaseActions;