"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStats = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSeverity = severity => {
  switch (severity) {
    case 'low':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: "#54b399"
      }), i18n.STATS_GROUP_SEVERITY_LOW);
    case 'medium':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: "#d6bf57"
      }), i18n.STATS_GROUP_SEVERITY_MEDIUM);
    case 'high':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: "#da8b45"
      }), i18n.STATS_GROUP_SEVERITY_HIGH);
    case 'critical':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "dot",
        color: "#e7664c"
      }), i18n.STATS_GROUP_SEVERITY_CRITICAL);
  }
  return null;
};
const multiSeverity = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
  className: "smallDot"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "dot",
  color: "#54b399"
})), /*#__PURE__*/_react.default.createElement("span", {
  className: "smallDot"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "dot",
  color: "#d6bf57"
})), /*#__PURE__*/_react.default.createElement("span", {
  className: "smallDot"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "dot",
  color: "#da8b45"
})), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "dot",
  color: "#e7664c"
})), i18n.STATS_GROUP_SEVERITY_MULTI);
const getStats = (selectedGroup, bucket) => {
  var _bucket$severitiesSub, _bucket$severitiesSub2, _bucket$severitiesSub3, _bucket$severitiesSub4, _bucket$countSeverity, _bucket$countSeverity2, _bucket$usersCountAgg, _bucket$usersCountAgg2, _bucket$hostsCountAgg, _bucket$hostsCountAgg2, _bucket$usersCountAgg3, _bucket$usersCountAgg4, _bucket$rulesCountAgg, _bucket$rulesCountAgg2, _bucket$hostsCountAgg3, _bucket$hostsCountAgg4, _bucket$rulesCountAgg3, _bucket$rulesCountAgg4, _bucket$hostsCountAgg5, _bucket$hostsCountAgg6, _bucket$rulesCountAgg5, _bucket$rulesCountAgg6, _bucket$rulesCountAgg7, _bucket$rulesCountAgg8;
  const singleSeverityComponent = (_bucket$severitiesSub = bucket.severitiesSubAggregation) !== null && _bucket$severitiesSub !== void 0 && _bucket$severitiesSub.buckets && (_bucket$severitiesSub2 = bucket.severitiesSubAggregation) !== null && _bucket$severitiesSub2 !== void 0 && (_bucket$severitiesSub3 = _bucket$severitiesSub2.buckets) !== null && _bucket$severitiesSub3 !== void 0 && _bucket$severitiesSub3.length ? getSeverity((_bucket$severitiesSub4 = bucket.severitiesSubAggregation) === null || _bucket$severitiesSub4 === void 0 ? void 0 : _bucket$severitiesSub4.buckets[0].key.toString()) : null;
  const severityComponent = (_bucket$countSeverity = bucket.countSeveritySubAggregation) !== null && _bucket$countSeverity !== void 0 && _bucket$countSeverity.value && ((_bucket$countSeverity2 = bucket.countSeveritySubAggregation) === null || _bucket$countSeverity2 === void 0 ? void 0 : _bucket$countSeverity2.value) > 1 ? multiSeverity : singleSeverityComponent;
  const severityStat = !severityComponent ? [] : [{
    title: i18n.STATS_GROUP_SEVERITY,
    renderer: severityComponent
  }];
  const defaultBadges = [{
    title: i18n.STATS_GROUP_ALERTS,
    badge: {
      value: bucket.doc_count,
      width: 50,
      color: '#a83632'
    }
  }];
  switch (selectedGroup) {
    case 'kibana.alert.rule.name':
      return [...severityStat, {
        title: i18n.STATS_GROUP_USERS,
        badge: {
          value: (_bucket$usersCountAgg = (_bucket$usersCountAgg2 = bucket.usersCountAggregation) === null || _bucket$usersCountAgg2 === void 0 ? void 0 : _bucket$usersCountAgg2.value) !== null && _bucket$usersCountAgg !== void 0 ? _bucket$usersCountAgg : 0
        }
      }, {
        title: i18n.STATS_GROUP_HOSTS,
        badge: {
          value: (_bucket$hostsCountAgg = (_bucket$hostsCountAgg2 = bucket.hostsCountAggregation) === null || _bucket$hostsCountAgg2 === void 0 ? void 0 : _bucket$hostsCountAgg2.value) !== null && _bucket$hostsCountAgg !== void 0 ? _bucket$hostsCountAgg : 0
        }
      }, ...defaultBadges];
    case 'host.name':
      return [...severityStat, {
        title: i18n.STATS_GROUP_USERS,
        badge: {
          value: (_bucket$usersCountAgg3 = (_bucket$usersCountAgg4 = bucket.usersCountAggregation) === null || _bucket$usersCountAgg4 === void 0 ? void 0 : _bucket$usersCountAgg4.value) !== null && _bucket$usersCountAgg3 !== void 0 ? _bucket$usersCountAgg3 : 0
        }
      }, {
        title: i18n.STATS_GROUP_RULES,
        badge: {
          value: (_bucket$rulesCountAgg = (_bucket$rulesCountAgg2 = bucket.rulesCountAggregation) === null || _bucket$rulesCountAgg2 === void 0 ? void 0 : _bucket$rulesCountAgg2.value) !== null && _bucket$rulesCountAgg !== void 0 ? _bucket$rulesCountAgg : 0
        }
      }, ...defaultBadges];
    case 'user.name':
      return [...severityStat, {
        title: i18n.STATS_GROUP_HOSTS,
        badge: {
          value: (_bucket$hostsCountAgg3 = (_bucket$hostsCountAgg4 = bucket.hostsCountAggregation) === null || _bucket$hostsCountAgg4 === void 0 ? void 0 : _bucket$hostsCountAgg4.value) !== null && _bucket$hostsCountAgg3 !== void 0 ? _bucket$hostsCountAgg3 : 0
        }
      }, {
        title: i18n.STATS_GROUP_RULES,
        badge: {
          value: (_bucket$rulesCountAgg3 = (_bucket$rulesCountAgg4 = bucket.rulesCountAggregation) === null || _bucket$rulesCountAgg4 === void 0 ? void 0 : _bucket$rulesCountAgg4.value) !== null && _bucket$rulesCountAgg3 !== void 0 ? _bucket$rulesCountAgg3 : 0
        }
      }, ...defaultBadges];
    case 'source.ip':
      return [...severityStat, {
        title: i18n.STATS_GROUP_HOSTS,
        badge: {
          value: (_bucket$hostsCountAgg5 = (_bucket$hostsCountAgg6 = bucket.hostsCountAggregation) === null || _bucket$hostsCountAgg6 === void 0 ? void 0 : _bucket$hostsCountAgg6.value) !== null && _bucket$hostsCountAgg5 !== void 0 ? _bucket$hostsCountAgg5 : 0
        }
      }, {
        title: i18n.STATS_GROUP_RULES,
        badge: {
          value: (_bucket$rulesCountAgg5 = (_bucket$rulesCountAgg6 = bucket.rulesCountAggregation) === null || _bucket$rulesCountAgg6 === void 0 ? void 0 : _bucket$rulesCountAgg6.value) !== null && _bucket$rulesCountAgg5 !== void 0 ? _bucket$rulesCountAgg5 : 0
        }
      }, ...defaultBadges];
  }
  return [...severityStat, {
    title: i18n.STATS_GROUP_RULES,
    badge: {
      value: (_bucket$rulesCountAgg7 = (_bucket$rulesCountAgg8 = bucket.rulesCountAggregation) === null || _bucket$rulesCountAgg8 === void 0 ? void 0 : _bucket$rulesCountAgg8.value) !== null && _bucket$rulesCountAgg7 !== void 0 ? _bucket$rulesCountAgg7 : 0
    }
  }, ...defaultBadges];
};
exports.getStats = getStats;