"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsProgressBar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helpers = require("./helpers");
var _draggables = require("../../../../common/components/draggables");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProgressWrapper = _styledComponents.default.div`
  height: 160px;
`;
const StyledEuiHorizontalRule = (0, _styledComponents.default)(_eui.EuiHorizontalRule)`
  margin-top: 0;
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-top: -${({
  theme
}) => theme.eui.euiSizeM};
`;
const StyledEuiProgress = (0, _styledComponents.default)(_eui.EuiProgress)`
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const DataStatsWrapper = _styledComponents.default.div`
  width: 250px;
`;
const AlertsProgressBar = ({
  data,
  isLoading,
  addFilter,
  groupBySelection
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(!isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const [nonEmpty, formattedNonEmptyPercent] = (0, _helpers.getAggregateData)(data);
  const dataStatsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    iconType: "iInCircle",
    "aria-label": "info",
    size: "xs",
    onClick: onButtonClick
  });
  const dataStatsMessage = /*#__PURE__*/_react.default.createElement(DataStatsWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, i18n.DATA_STATISTICS_TITLE(formattedNonEmptyPercent)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, i18n.DATA_STATISTICS_MESSAGE(groupBySelection), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "primary",
    onClick: () => {
      setIsPopoverOpen(false);
      if (addFilter) {
        addFilter({
          field: groupBySelection,
          value: null,
          negate: true
        });
      }
    }
  }, i18n.NON_EMPTY_FILTER(groupBySelection))));
  const labelWithHoverActions = key => {
    return /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
      isDraggable: false,
      field: groupBySelection,
      hideTopN: true,
      id: `top-alerts-${key}`,
      value: key,
      queryValue: key,
      tooltipContent: null
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      className: "eui-textTruncate"
    }, key));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "alerts-progress-bar-title"
  }, /*#__PURE__*/_react.default.createElement("h5", null, groupBySelection))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: dataStatsButton,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "rightCenter",
    panelPaddingSize: "s"
  }, dataStatsMessage))), isLoading ? /*#__PURE__*/_react.default.createElement(StyledEuiProgress, {
    size: "xs",
    color: "primary"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(ProgressWrapper, {
    "data-test-subj": "progress-bar",
    className: "eui-yScroll"
  }, nonEmpty === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center",
    "data-test-subj": "empty-proress-bar"
  }, i18n.EMPTY_DATA_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.map(item => item.key !== '-' && /*#__PURE__*/_react.default.createElement("div", {
    key: `${item.key}`,
    "data-test-subj": `progress-bar-${item.key}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    valueText: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "default"
    }, /*#__PURE__*/_react.default.createElement("strong", null, item.percentageLabel)),
    max: 1,
    color: `vis9`,
    size: "s",
    value: item.percentage,
    label: item.key === 'Other' ? item.label : labelWithHoverActions(item.key)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))));
};
exports.AlertsProgressBar = AlertsProgressBar;
AlertsProgressBar.displayName = 'AlertsProgressBar';