"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryInvestigationGuidePanel = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const panelCss = {
  marginBottom: '16px'
};
const flexGroupCss = {
  padding: `0 24px`
};
const OsqueryInvestigationGuidePanel = /*#__PURE__*/_react.default.memo(({
  onClick,
  queriesLength
}) => {
  const [hideInvestigationGuideSuggestion, setHideInvestigationGuideSuggestion] = (0, _react.useState)(false);
  const handleClick = (0, _react.useCallback)(() => {
    onClick();
    setHideInvestigationGuideSuggestion(true);
  }, [onClick]);
  if (hideInvestigationGuideSuggestion) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: 'primary',
    paddingSize: 'xs',
    css: panelCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'row',
    alignItems: 'center',
    css: flexGroupCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    "data-test-subj": 'osquery-investigation-guide-text'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responseActionsList.investigationGuideSuggestion",
    defaultMessage: "You have {queriesLength, plural, one {a query} other {queries}} in the investigation guide. Add {queriesLength, plural, one {it as a response action} other {them as response actions}}?",
    values: {
      queriesLength
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: 'm',
    color: 'primary',
    onClick: handleClick,
    "data-test-subj": 'osqueryAddInvestigationGuideQueries'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responseActionsList.addButton",
    defaultMessage: "Add"
  }))))));
});
exports.OsqueryInvestigationGuidePanel = OsqueryInvestigationGuidePanel;
OsqueryInvestigationGuidePanel.displayName = 'OsqueryInvestigationGuidePanel';