"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewTacticPanel = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireWildcard(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _panel_rule_stats = require("./shared_components/panel_rule_stats");
var _mitre_technique = require("../../../rule_management/model/coverage_overview/mitre_technique");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CoverageOverviewTacticPanelComponent = ({
  tactic
}) => {
  const coveredTechniques = (0, _react.useMemo)(() => (0, _mitre_technique.getNumOfCoveredTechniques)(tactic), [tactic]);
  const ProgressLabel = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "success"
  }, /*#__PURE__*/_react.default.createElement("h5", null, i18n.COVERED_MITRE_TECHNIQUES(coveredTechniques, tactic.techniques.length))), [tactic.techniques, coveredTechniques]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "coverageOverviewTacticPanel",
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s",
    className: (0, _css.css)`
        background: ${_uiTheme.euiThemeVars.euiColorLightestShade};
        border-color: ${_uiTheme.euiThemeVars.euiColorMediumShade};
        width: ${_constants.coverageOverviewPanelWidth}px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tactic.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: (0, _css.css)`
            h4 {
              white-space: nowrap;
              overflow: hidden;
              text-overflow: ellipsis;
            }
          `,
    "aria-label": tactic.name,
    title: tactic.name,
    grow: false,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, tactic.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    color: "success",
    value: coveredTechniques,
    label: ProgressLabel,
    max: tactic.techniques.length
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_panel_rule_stats.CoverageOverviewPanelRuleStats, {
    enabledRules: tactic.enabledRules.length,
    disabledRules: tactic.disabledRules.length
  }));
};
const CoverageOverviewTacticPanel = /*#__PURE__*/(0, _react.memo)(CoverageOverviewTacticPanelComponent);
exports.CoverageOverviewTacticPanel = CoverageOverviewTacticPanel;