"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCoverageOverviewDashboardReducer = exports.SET_SHOW_EXPANDED_CELLS = exports.SET_RULE_SOURCE_FILTER = exports.SET_RULE_SEARCH_FILTER = exports.SET_RULE_ACTIVITY_FILTER = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Action type names
const SET_SHOW_EXPANDED_CELLS = 'setShowExpandedCells';
exports.SET_SHOW_EXPANDED_CELLS = SET_SHOW_EXPANDED_CELLS;
const SET_RULE_ACTIVITY_FILTER = 'setRuleActivityFilter';
exports.SET_RULE_ACTIVITY_FILTER = SET_RULE_ACTIVITY_FILTER;
const SET_RULE_SOURCE_FILTER = 'setRuleSourceFilter';
exports.SET_RULE_SOURCE_FILTER = SET_RULE_SOURCE_FILTER;
const SET_RULE_SEARCH_FILTER = 'setRuleSearchFilter';
exports.SET_RULE_SEARCH_FILTER = SET_RULE_SEARCH_FILTER;
const createCoverageOverviewDashboardReducer = () => (state, action) => {
  switch (action.type) {
    case SET_SHOW_EXPANDED_CELLS:
      {
        const {
          value
        } = action;
        return {
          ...state,
          showExpandedCells: value
        };
      }
    case SET_RULE_ACTIVITY_FILTER:
      {
        const {
          value
        } = action;
        const updatedFilter = {
          ...state.filter,
          activity: value.length !== 0 ? value : undefined
        };
        return {
          ...state,
          filter: updatedFilter
        };
      }
    case SET_RULE_SOURCE_FILTER:
      {
        const {
          value
        } = action;
        const updatedFilter = {
          ...state.filter,
          source: value.length !== 0 ? value : undefined
        };
        return {
          ...state,
          filter: updatedFilter
        };
      }
    case SET_RULE_SEARCH_FILTER:
      {
        const {
          value
        } = action;
        const updatedFilter = {
          ...state.filter,
          search_term: value.length !== 0 ? value : undefined
        };
        return {
          ...state,
          filter: updatedFilter
        };
      }
    default:
      return state;
  }
};
exports.createCoverageOverviewDashboardReducer = createCoverageOverviewDashboardReducer;