"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCoverageOverviewDashboardContext = exports.initialState = exports.CoverageOverviewDashboardContextProvider = exports.CoverageOverviewDashboardContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _invariant = require("../../../../../common/utils/invariant");
var _detection_engine = require("../../../../../common/api/detection_engine");
var _coverage_overview_dashboard_reducer = require("./coverage_overview_dashboard_reducer");
var _use_fetch_coverage_overview_query = require("../../../rule_management/api/hooks/use_fetch_coverage_overview_query");
var _use_execute_bulk_action = require("../../../rule_management/logic/bulk_actions/use_execute_bulk_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CoverageOverviewDashboardContext = /*#__PURE__*/(0, _react.createContext)(null);
exports.CoverageOverviewDashboardContext = CoverageOverviewDashboardContext;
const initialState = {
  showExpandedCells: false,
  filter: {
    activity: [_detection_engine.CoverageOverviewRuleActivity.Enabled],
    source: [_detection_engine.CoverageOverviewRuleSource.Prebuilt, _detection_engine.CoverageOverviewRuleSource.Custom]
  },
  data: undefined,
  isLoading: false
};
exports.initialState = initialState;
const CoverageOverviewDashboardContextProvider = ({
  children
}) => {
  const [state, dispatch] = (0, _react.useReducer)((0, _coverage_overview_dashboard_reducer.createCoverageOverviewDashboardReducer)(), initialState);
  const {
    data,
    isLoading,
    refetch
  } = (0, _use_fetch_coverage_overview_query.useFetchCoverageOverviewQuery)(state.filter);
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)();
  (0, _react.useEffect)(() => {
    refetch();
  }, [refetch, state.filter]);
  const setShowExpandedCells = (0, _react.useCallback)(value => {
    dispatch({
      type: _coverage_overview_dashboard_reducer.SET_SHOW_EXPANDED_CELLS,
      value
    });
  }, [dispatch]);
  const setRuleActivityFilter = (0, _react.useCallback)(value => {
    dispatch({
      type: _coverage_overview_dashboard_reducer.SET_RULE_ACTIVITY_FILTER,
      value
    });
  }, [dispatch]);
  const setRuleSourceFilter = (0, _react.useCallback)(value => {
    dispatch({
      type: _coverage_overview_dashboard_reducer.SET_RULE_SOURCE_FILTER,
      value
    });
  }, [dispatch]);
  const setRuleSearchFilter = (0, _react.useCallback)(value => {
    dispatch({
      type: _coverage_overview_dashboard_reducer.SET_RULE_SEARCH_FILTER,
      value
    });
  }, [dispatch]);
  const enableAllDisabled = (0, _react.useCallback)(async ruleIds => {
    await executeBulkAction({
      type: _detection_engine.BulkActionTypeEnum.enable,
      ids: ruleIds
    });
  }, [executeBulkAction]);
  const actions = (0, _react.useMemo)(() => ({
    refetch,
    setShowExpandedCells,
    setRuleActivityFilter,
    setRuleSourceFilter,
    setRuleSearchFilter,
    enableAllDisabled
  }), [refetch, setRuleActivityFilter, setRuleSearchFilter, setRuleSourceFilter, setShowExpandedCells, enableAllDisabled]);
  const providerValue = (0, _react.useMemo)(() => {
    return {
      state: {
        ...state,
        isLoading,
        data
      },
      actions
    };
  }, [actions, data, isLoading, state]);
  return /*#__PURE__*/_react.default.createElement(CoverageOverviewDashboardContext.Provider, {
    value: providerValue
  }, children);
};
exports.CoverageOverviewDashboardContextProvider = CoverageOverviewDashboardContextProvider;
const useCoverageOverviewDashboardContext = () => {
  const dashboardContext = (0, _react.useContext)(CoverageOverviewDashboardContext);
  (0, _invariant.invariant)(dashboardContext, 'useCoverageOverviewDashboardContext should be used inside CoverageOverviewDashboardContextProvider');
  return dashboardContext;
};
exports.useCoverageOverviewDashboardContext = useCoverageOverviewDashboardContext;