"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHasMlPermissions = void 0;
var _has_ml_admin_permissions = require("../../../../../common/machine_learning/has_ml_admin_permissions");
var _has_ml_license = require("../../../../../common/machine_learning/has_ml_license");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHasMlPermissions = () => {
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();

  // TODO: Refactor license check + hasMlAdminPermissions to common check
  return (0, _has_ml_license.hasMlLicense)(mlCapabilities) && (0, _has_ml_admin_permissions.hasMlAdminPermissions)(mlCapabilities);
};
exports.useHasMlPermissions = useHasMlPermissions;