"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTableUrlSavedPagination = exports.RulesTableStorageSavedPagination = exports.RulesTableSavedSorting = exports.RulesTableSavedFilter = exports.RuleSource = void 0;
var z = _interopRequireWildcard(require("zod"));
var _detection_engine = require("../../../../../../common/api/detection_engine");
var _logic = require("../../../../rule_management/logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RuleSource;
exports.RuleSource = RuleSource;
(function (RuleSource) {
  RuleSource["Prebuilt"] = "prebuilt";
  RuleSource["Custom"] = "custom";
})(RuleSource || (exports.RuleSource = RuleSource = {}));
const RulesTableSavedFilter = z.object({
  searchTerm: z.string(),
  source: z.nativeEnum(RuleSource),
  tags: z.array(z.string()),
  enabled: z.boolean(),
  ruleExecutionStatus: _detection_engine.RuleExecutionStatus
}).partial();
exports.RulesTableSavedFilter = RulesTableSavedFilter;
const RulesTableSavedSorting = _logic.SortingOptions.pick({
  field: true,
  order: true
}).partial();
exports.RulesTableSavedSorting = RulesTableSavedSorting;
const RulesTableStorageSavedPagination = _logic.PaginationOptions.pick({
  perPage: true
}).partial();
exports.RulesTableStorageSavedPagination = RulesTableStorageSavedPagination;
const RulesTableUrlSavedPagination = _logic.PaginationOptions.pick({
  page: true,
  perPage: true
}).partial();
exports.RulesTableUrlSavedPagination = RulesTableUrlSavedPagination;