"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_FIRST_RULE_TITLE = exports.SEARCH_FIRST_RULE_CONTENT = exports.NEXT_BUTTON = exports.INSTALL_PREBUILT_RULES_TITLE = exports.INSTALL_PREBUILT_RULES_CONTENT = exports.ENABLE_FIRST_RULE_TITLE = exports.ENABLE_FIRST_RULE_CONTENT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTALL_PREBUILT_RULES_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.guidedOnboarding.installPrebuiltRules.title', {
  defaultMessage: 'Install your first prebuilt rule'
});
exports.INSTALL_PREBUILT_RULES_TITLE = INSTALL_PREBUILT_RULES_TITLE;
const INSTALL_PREBUILT_RULES_CONTENT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.guidedOnboarding.installPrebuiltRules.content', {
  defaultMessage: 'Navigate to the Add Elastic Rules page and install the example "My First Rule".'
});
exports.INSTALL_PREBUILT_RULES_CONTENT = INSTALL_PREBUILT_RULES_CONTENT;
const SEARCH_FIRST_RULE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.guidedOnboarding.searchFirstRule.title', {
  defaultMessage: 'Find your first rule'
});
exports.SEARCH_FIRST_RULE_TITLE = SEARCH_FIRST_RULE_TITLE;
const SEARCH_FIRST_RULE_CONTENT = name => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.guidedOnboarding.searchFirstRule.content', {
  defaultMessage: 'Search for "{name}" or click next.',
  values: {
    name
  }
});
exports.SEARCH_FIRST_RULE_CONTENT = SEARCH_FIRST_RULE_CONTENT;
const ENABLE_FIRST_RULE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.guidedOnboarding.enableFirstRule.title', {
  defaultMessage: 'Enable the rule'
});
exports.ENABLE_FIRST_RULE_TITLE = ENABLE_FIRST_RULE_TITLE;
const ENABLE_FIRST_RULE_CONTENT = name => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.guidedOnboarding.enableFirstRule.content', {
  defaultMessage: 'Enable "{name}" or click next.',
  values: {
    name
  }
});
exports.ENABLE_FIRST_RULE_CONTENT = ENABLE_FIRST_RULE_CONTENT;
const NEXT_BUTTON = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.guidedOnboarding.nextButton', {
  defaultMessage: 'Next'
});
exports.NEXT_BUTTON = NEXT_BUTTON;