"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_CAPABILITIES_TOUR_ANCHOR = exports.RulesFeatureTour = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _kibana = require("../../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_CAPABILITIES_TOUR_ANCHOR = 'search-capabilities-tour-anchor';
exports.SEARCH_CAPABILITIES_TOUR_ANCHOR = SEARCH_CAPABILITIES_TOUR_ANCHOR;
const TOUR_STORAGE_KEY = _constants.NEW_FEATURES_TOUR_STORAGE_KEYS.RULE_MANAGEMENT_PAGE;
const TOUR_POPOVER_WIDTH = 400;
const tourConfig = {
  currentTourStep: 1,
  isTourActive: true,
  tourPopoverWidth: TOUR_POPOVER_WIDTH,
  tourSubtitle: i18n.TOUR_TITLE
};
const stepsConfig = [{
  step: 1,
  title: i18n.SEARCH_CAPABILITIES_TITLE,
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.SEARCH_CAPABILITIES_DESCRIPTION),
  stepsTotal: 1,
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
  onFinish: _lodash.noop,
  maxWidth: TOUR_POPOVER_WIDTH
}];
const RulesFeatureTour = () => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const restoredState = (0, _react.useMemo)(() => ({
    ...tourConfig,
    ...storage.get(TOUR_STORAGE_KEY)
  }), [storage]);
  const [tourSteps, tourActions, tourState] = (0, _eui.useEuiTour)(stepsConfig, restoredState);
  (0, _react.useEffect)(() => {
    const {
      isTourActive,
      currentTourStep
    } = tourState;
    storage.set(TOUR_STORAGE_KEY, {
      isTourActive,
      currentTourStep
    });
  }, [tourState, storage]);
  const [shouldShowSearchCapabilitiesTour, setShouldShowSearchCapabilitiesTour] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    /**
     * Wait until the tour target elements are visible on the page and mount
     * EuiTourStep components only after that. Otherwise, the tours would never
     * show up on the page.
     */
    const observer = new MutationObserver(() => {
      if (document.querySelector(`#${SEARCH_CAPABILITIES_TOUR_ANCHOR}`)) {
        setShouldShowSearchCapabilitiesTour(true);
        observer.disconnect();
      }
    });
    observer.observe(document.body, {
      childList: true,
      subtree: true
    });
    return () => observer.disconnect();
  }, []);
  const enhancedSteps = (0, _react.useMemo)(() => tourSteps.map((item, index) => ({
    ...item,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, item.content, tourSteps.length > 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "arrowLeft",
      "aria-label": i18n.PREVIOUS_STEP_LABEL,
      display: "empty",
      disabled: index === 0,
      onClick: tourActions.decrementStep
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "arrowRight",
      "aria-label": i18n.NEXT_STEP_LABEL,
      display: "base",
      disabled: index === tourSteps.length - 1,
      onClick: tourActions.incrementStep
    })))))
  })), [tourSteps, tourActions]);
  return shouldShowSearchCapabilitiesTour ? /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, (0, _extends2.default)({}, enhancedSteps[0], {
    /**
     * children={undefined} is needed to narrow down EuiTourStepProps. Without
     * it we get a TS error: Types of property 'anchor' are incompatible.
     */
    // eslint-disable-next-line react/no-children-prop
    children: undefined,
    anchor: `#${SEARCH_CAPABILITIES_TOUR_ANCHOR}`,
    anchorPosition: "downCenter"
  })) : null;
};
exports.RulesFeatureTour = RulesFeatureTour;