"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesPageTourComponent = void 0;
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _react = _interopRequireWildcard(require("react"));
var _siem_guide_config = require("../../../../../../common/guided_onboarding/siem_guide_config");
var _constants = require("../../../../../../common/constants");
var _kibana = require("../../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesPageTourComponent = ({
  children
}) => {
  var _guidedOnboarding$gui, _guidedOnboarding$gui2;
  const tourConfig = {
    currentTourStep: 1,
    isTourActive: true,
    tourPopoverWidth: 300
  };
  const {
    storage,
    guidedOnboarding
  } = (0, _kibana.useKibana)().services;
  const isGuidedOnboardingActive = (0, _useObservable.default)((_guidedOnboarding$gui = guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui2 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui2 === void 0 ? void 0 : _guidedOnboarding$gui2.isGuideStepActive$(_siem_guide_config.siemGuideId, 'rules')) !== null && _guidedOnboarding$gui !== void 0 ? _guidedOnboarding$gui : (0, _rxjs.of)(false), true);
  const [tourState, setTourState] = (0, _react.useState)(() => {
    const restoredTourState = storage.get(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.RULE_MANAGEMENT_PAGE);
    if (restoredTourState != null) {
      return restoredTourState;
    }
    return tourConfig;
  });
  const demoTourSteps = [{
    step: 1,
    title: i18n.CREATE_RULE_TOUR_TITLE,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.CREATE_RULE_TOUR_CONTENT)
  }];
  const finishTour = (0, _react.useCallback)(() => {
    setTourState({
      ...tourState,
      isTourActive: false
    });
  }, [tourState]);
  (0, _react.useEffect)(() => {
    storage.set(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.RULE_MANAGEMENT_PAGE, tourState);
  }, [tourState, storage]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: demoTourSteps[0].content,
    isStepOpen: tourState.currentTourStep === 1 && tourState.isTourActive && !isGuidedOnboardingActive,
    minWidth: tourState.tourPopoverWidth,
    onFinish: finishTour,
    step: 1,
    stepsTotal: demoTourSteps.length,
    subtitle: tourState.tourSubtitle,
    title: demoTourSteps[0].title,
    anchorPosition: "rightUp"
  }, children);
};
exports.RulesPageTourComponent = RulesPageTourComponent;