"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MiniCallout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A customized mini variant of the EuiCallOut component. Includes additional styling overrides
 * for displaying rich titles when callout size="s", and an option enabling dismissal.
 *
 * @param color color for the callout, defaults to 'primary'
 * @param dismissible whether the callout can be dismissed, defaults to 'true'
 * @param iconType icon for the callout
 * @param title ReactNode or string title text to be displayed
 *
 * @constructor
 */
const MiniCalloutComponent = ({
  color = 'primary',
  dismissible = true,
  iconType,
  title
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isDismissed, setIsDismissed] = (0, _react.useState)(false);
  if (isDismissed) {
    return null;
  }
  const calloutTitle = /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 97%;
        margin-left: ${euiTheme.size.s};
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    css: (0, _react2.css)`
          display: flex;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "default",
    css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.regular};
              `
  }, title))), dismissible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.regular};
              `,
    onClick: () => setIsDismissed(true)
  }, i18n.DISMISS))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: color,
    "data-test-subj": "mini-callout"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex'
    }
  }, iconType && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    color: color
  }), calloutTitle));
};
const MiniCallout = /*#__PURE__*/_react.default.memo(MiniCalloutComponent);
exports.MiniCallout = MiniCallout;
MiniCallout.displayName = 'MiniCallout';