"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOverviewTabSections = exports.RuleOverviewTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _rule_about_section = require("./rule_about_section");
var _rule_definition_section = require("./rule_definition_section");
var _rule_schedule_section = require("./rule_schedule_section");
var _rule_setup_guide_section = require("./rule_setup_guide_section");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultOverviewOpenSections = {
  about: true,
  definition: true,
  schedule: true,
  setup: true
};
const useOverviewTabSections = () => {
  const [expandedOverviewSections, setOpenOverviewSections] = (0, _react.useState)(defaultOverviewOpenSections);
  const toggleSection = (0, _react.useCallback)(sectionName => {
    setOpenOverviewSections(prevOpenSections => ({
      ...prevOpenSections,
      [sectionName]: !prevOpenSections[sectionName]
    }));
  }, []);
  const toggleOverviewSection = (0, _react.useMemo)(() => ({
    about: () => toggleSection('about'),
    definition: () => toggleSection('definition'),
    schedule: () => toggleSection('schedule'),
    setup: () => toggleSection('setup')
  }), [toggleSection]);
  return {
    expandedOverviewSections,
    toggleOverviewSection
  };
};
exports.useOverviewTabSections = useOverviewTabSections;
const ExpandableSection = ({
  title,
  isOpen,
  toggle,
  children
}) => {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordion'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    forceState: isOpen ? 'open' : 'closed',
    onToggle: toggle,
    paddingSize: "none",
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, title)),
    initialIsOpen: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, children));
};
const RuleOverviewTab = ({
  rule,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  expandedOverviewSections,
  toggleOverviewSection
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.ABOUT_SECTION_LABEL,
    isOpen: expandedOverviewSections.about,
    toggle: toggleOverviewSection.about
  }, rule.description && /*#__PURE__*/_react.default.createElement(_rule_about_section.Description, {
    description: rule.description
  }), /*#__PURE__*/_react.default.createElement(_rule_about_section.RuleAboutSection, {
    rule: rule,
    columnWidths: columnWidths,
    hideDescription: true,
    hideName: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.DEFINITION_SECTION_LABEL,
    isOpen: expandedOverviewSections.definition,
    toggle: toggleOverviewSection.definition
  }, /*#__PURE__*/_react.default.createElement(_rule_definition_section.RuleDefinitionSection, {
    rule: rule,
    columnWidths: columnWidths
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.SCHEDULE_SECTION_LABEL,
    isOpen: expandedOverviewSections.schedule,
    toggle: toggleOverviewSection.schedule
  }, /*#__PURE__*/_react.default.createElement(_rule_schedule_section.RuleScheduleSection, {
    rule: rule,
    columnWidths: columnWidths
  })), rule.setup && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.SETUP_GUIDE_SECTION_LABEL,
    isOpen: expandedOverviewSections.setup,
    toggle: toggleOverviewSection.setup
  }, /*#__PURE__*/_react.default.createElement(_rule_setup_guide_section.RuleSetupGuideSection, {
    setup: rule.setup
  }))));
};
exports.RuleOverviewTab = RuleOverviewTab;