"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDiffTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
var _eui = require("@elastic/eui");
var _utils = require("../../../../../common/detection_engine/utils");
var _helpers = require("../../../rule_creation_ui/pages/rule_creation/helpers");
var _diff_view = require("./json_diff/diff_view");
var i18n = _interopRequireWildcard(require("./json_diff/translations"));
var _helpers2 = require("../../../../detections/pages/detection_engine/rules/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* Inclding these properties in diff display might be confusing to users. */
const HIDDEN_PROPERTIES = [
/*
  By default, prebuilt rules don't have any actions or exception lists. So if a user has defined actions or exception lists for a rule, it'll show up as diff. This looks confusing as the user might think that their actions and exceptions lists will get removed after the upgrade, which is not the case - they will be preserved.
*/
'actions', 'exceptions_list',
/*
  Most prebuilt rules are installed as "disabled". Once user enables a rule, it'll show as diff, which doesn't add value.
*/
'enabled', /* Technical property. Hidden because it can be confused with "version" by users. */
'revision',
/*
  "updated_at" value is regenerated on every '/upgrade/_review' endpoint run 
  and will therefore always show a diff. It adds no value to display it to the user.
*/
'updated_at'];
const sortAndStringifyJson = jsObject => (0, _jsonStableStringify.default)(jsObject, {
  space: 2
});

/**
 * Normalizes the rule object, making it suitable for comparison with another normalized rule.
 *
 * Normalization is needed to avoid showing diffs for semantically equal property values.
 * Saving a rule via the rule editing UI might change the format of some properties or set default values.
 * This function compensates for those changes.
 *
 * @param {RuleResponse} originalRule - Rule of a RuleResponse type.
 * @returns {RuleResponse} - The updated normalized rule object.
 */
const normalizeRule = originalRule => {
  var _rule$note;
  const rule = {
    ...originalRule
  };

  /*
    Convert the "from" property value to a humanized duration string, like 'now-1m' or 'now-2h'. 
    Conversion is needed to skip showing the diff for the "from" property when the same 
    duration is represented in different time units. For instance, 'now-1h' and 'now-3600s' 
    indicate a one-hour duration.
    The same helper is used in the rule editing UI to format "from" before submitting the edits. 
    So, after the rule is saved, the "from" property unit/value might differ from what's in the package.
  */
  rule.from = (0, _helpers.formatScheduleStepData)({
    interval: rule.interval,
    from: (0, _helpers2.getHumanizedDuration)(rule.from, rule.interval),
    to: rule.to
  }).from;

  /*
    Default "note" to an empty string if it's not present.
    Sometimes, in a new version of a rule, the "note" value equals an empty string, while 
    in the old version, it wasn't specified at all (undefined becomes ''). In this case, 
    it doesn't make sense to show diff, so we default falsy values to ''.
  */
  rule.note = (_rule$note = rule.note) !== null && _rule$note !== void 0 ? _rule$note : '';

  /*
    Removes empty arrays (techniques, subtechniques) from the MITRE ATT&CK value.
    The same processing is done in the rule editing UI before submitting the edits.
  */
  rule.threat = (0, _helpers.filterEmptyThreats)(rule.threat);

  /*
    The "machine_learning_job_id" property is converted from the legacy string format 
    to the new array format during installation and upgrade. Thus, all installed rules 
    use the new format. For correct comparison, we must ensure that the rule update is 
    also in the new format before showing the diff.
  */
  if ('machine_learning_job_id' in rule) {
    rule.machine_learning_job_id = (0, _utils.normalizeMachineLearningJobIds)(rule.machine_learning_job_id);
  }

  /*
    Default the "alias" property to null for all threat filters that don't have it.
    Setting a default is needed to match the behavior of the rule editing UI, 
    which also defaults the "alias" property to null.
  */
  if (rule.type === 'threat_match' && Array.isArray(rule.threat_filters)) {
    const threatFiltersWithDefaultMeta = rule.threat_filters.map(filter => {
      if (!filter.meta.alias) {
        return {
          ...filter,
          meta: {
            ...filter.meta,
            alias: null
          }
        };
      }
      return filter;
    });
    rule.threat_filters = threatFiltersWithDefaultMeta;
  }
  return rule;
};
const RuleDiffTab = ({
  oldRule,
  newRule
}) => {
  const [oldSource, newSource] = (0, _react.useMemo)(() => {
    const visibleNewRuleProperties = (0, _lodash.omit)(normalizeRule(newRule), ...HIDDEN_PROPERTIES);
    const visibleOldRuleProperties = (0, _lodash.omit)( /* Only compare properties that are present in the update. */
    (0, _lodash.pick)(normalizeRule(oldRule), Object.keys(visibleNewRuleProperties)));
    return [sortAndStringifyJson(visibleOldRuleProperties), sortAndStringifyJson(visibleNewRuleProperties)];
  }, [oldRule, newRule]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "subdued",
    content: i18n.BASE_VERSION_DESCRIPTION,
    type: "iInCircle",
    size: "m",
    display: "block"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, i18n.BASE_VERSION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "subdued",
    content: i18n.UPDATED_VERSION_DESCRIPTION,
    type: "iInCircle",
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, i18n.UPDATED_VERSION)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    size: "full"
  }), /*#__PURE__*/_react.default.createElement(_diff_view.DiffView, {
    oldSource: oldSource,
    newSource: newSource
  })));
};
exports.RuleDiffTab = RuleDiffTab;