"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.highlightedFieldsPrefixToExclude = exports.getKibanaAlertIdField = exports.KIBANA_ALERT_RULE_UUID = exports.KIBANA_ALERT_RULE_TYPE = exports.EVENT_CODE = exports.EVENT_CATEGORY = exports.ENDPOINT_ALERT = exports.AGENT_TYPE = exports.AGENT_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The highlightedFieldsPrefixToExclude is an array of prefixes
 * that should be disregarded in the Rule Exception.These prefixes
 * are irrelevant to the exception and should be ignored,even if
 * they were retrieved as Highlighted Fields from the "getEventFieldsToDisplay".
 */
const highlightedFieldsPrefixToExclude = ['kibana.alert.rule', 'signal.rule', 'rule'];
exports.highlightedFieldsPrefixToExclude = highlightedFieldsPrefixToExclude;
const getKibanaAlertIdField = id => `kibana.alert.${id}`;
exports.getKibanaAlertIdField = getKibanaAlertIdField;
const EVENT_CATEGORY = 'event.category';
exports.EVENT_CATEGORY = EVENT_CATEGORY;
const EVENT_CODE = 'event.code';
exports.EVENT_CODE = EVENT_CODE;
const KIBANA_ALERT_RULE_TYPE = 'kibana.alert.rule.type';
exports.KIBANA_ALERT_RULE_TYPE = KIBANA_ALERT_RULE_TYPE;
const AGENT_ID = 'agent.id';
exports.AGENT_ID = AGENT_ID;
const AGENT_TYPE = 'agent.type';
exports.AGENT_TYPE = AGENT_TYPE;
const KIBANA_ALERT_RULE_UUID = 'kibana.alert.rule.uuid';
exports.KIBANA_ALERT_RULE_UUID = KIBANA_ALERT_RULE_UUID;
const ENDPOINT_ALERT = 'endpoint';
exports.ENDPOINT_ALERT = ENDPOINT_ALERT;