"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemComments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("../../utils/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMMENT_ACCORDION_BUTTON_CLASS_NAME = 'exceptionCommentAccordionButton';
const MyAvatar = (0, _styledComponents.default)(_eui.EuiAvatar)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    margin-right: ${theme.eui.euiSizeS};
  `}
`;
const CommentAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    .${COMMENT_ACCORDION_BUTTON_CLASS_NAME} {
      color: ${theme.eui.euiColorPrimary};
      padding: ${theme.eui.euiSizeM} 0;
    }
  `}
`;
const ExceptionItemComments = /*#__PURE__*/(0, _react.memo)(function ExceptionItemComments({
  exceptionItemComments,
  newCommentValue,
  accordionTitle,
  initialIsOpen = false,
  newCommentOnChange,
  setCommentError
}) {
  const [errorExists, setErrorExists] = (0, _react.useState)(false);
  const [shouldShowComments, setShouldShowComments] = (0, _react.useState)(false);
  const currentUser = (0, _kibana.useCurrentUser)();
  const fullName = currentUser === null || currentUser === void 0 ? void 0 : currentUser.fullName;
  const userName = currentUser === null || currentUser === void 0 ? void 0 : currentUser.username;
  const userEmail = currentUser === null || currentUser === void 0 ? void 0 : currentUser.email;
  const avatarName = (0, _react.useMemo)(() => {
    if (fullName && fullName.length > 0) {
      return fullName;
    }

    // Did email second because for cloud users, username is a uuid,
    // so favor using name or email prior to using the cloud generated id
    if (userEmail && userEmail.length > 0) {
      return userEmail;
    }
    return userName && userName.length > 0 ? userName : i18n.UNKNOWN_AVATAR_NAME;
  }, [fullName, userEmail, userName]);
  (0, _react.useEffect)(() => {
    setCommentError(errorExists);
  }, [errorExists, setCommentError]);
  const handleOnChange = (0, _react.useCallback)(event => {
    newCommentOnChange(event.target.value);
    setErrorExists(event.target.value.length > _constants.MAX_COMMENT_LENGTH);
  }, [newCommentOnChange]);
  const handleTriggerOnClick = (0, _react.useCallback)(isOpen => {
    setShouldShowComments(isOpen);
  }, []);
  const commentsAccordionTitle = (0, _react.useMemo)(() => {
    if (exceptionItemComments && exceptionItemComments.length > 0) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        "data-test-subj": "ExceptionItemCommentsAccordionButton"
      }, !shouldShowComments ? i18n.COMMENTS_SHOW(exceptionItemComments.length) : i18n.COMMENTS_HIDE(exceptionItemComments.length));
    } else {
      return null;
    }
  }, [exceptionItemComments, shouldShowComments]);
  const formattedComments = (0, _react.useMemo)(() => {
    if (exceptionItemComments && exceptionItemComments.length > 0) {
      return (0, _helpers.getFormattedComments)(exceptionItemComments);
    } else {
      return [];
    }
  }, [exceptionItemComments]);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(CommentAccordion, {
    initialIsOpen: initialIsOpen && !!newCommentValue,
    id: 'add-exception-comments-accordion',
    buttonClassName: COMMENT_ACCORDION_BUTTON_CLASS_NAME,
    buttonContent: accordionTitle !== null && accordionTitle !== void 0 ? accordionTitle : commentsAccordionTitle,
    "data-test-subj": "exceptionItemCommentsAccordion",
    onToggle: isOpen => handleTriggerOnClick(isOpen)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    comments: formattedComments
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(MyAvatar, {
    name: avatarName,
    size: "l",
    "data-test-subj": "exceptionItemCommentAvatar"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: i18n.COMMENT_MAX_LENGTH_ERROR(_constants.MAX_COMMENT_LENGTH),
    isInvalid: errorExists
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    placeholder: i18n.ADD_COMMENT_PLACEHOLDER,
    "aria-label": "Comment Input",
    value: newCommentValue,
    onChange: handleOnChange,
    fullWidth: true,
    "data-test-subj": "newExceptionItemCommentTextArea"
  }))))));
});
exports.ExceptionItemComments = ExceptionItemComments;