"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkListSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkListSwitch = /*#__PURE__*/(0, _react.memo)(({
  list,
  linkedList,
  onListLinkChange,
  dataTestSubj
}) => {
  const isListLinked = (0, _react.useMemo)(() => Boolean(linkedList.find(l => l.id === list.id)), [linkedList, list.id]);
  const onLinkOrUnlinkList = (0, _react.useCallback)(({
    target: {
      checked
    }
  }) => {
    const newLinkedLists = !checked ? linkedList === null || linkedList === void 0 ? void 0 : linkedList.filter(item => item.id !== list.id) : [...linkedList, list];
    if (typeof onListLinkChange === 'function') onListLinkChange(newLinkedLists);
  }, [linkedList, onListLinkChange, list]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": dataTestSubj,
    onChange: onLinkOrUnlinkList,
    label: "",
    checked: isListLinked
  }));
});
exports.LinkListSwitch = LinkListSwitch;
LinkListSwitch.displayName = 'LinkListSwitch';