"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardToolBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/dashboard-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _common = require("../../../common");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DashboardToolBarComponent = ({
  dashboardContainer,
  onLoad
}) => {
  var _dashboardContainer$s;
  const {
    setHeaderActionMenu
  } = (0, _kibana.useKibana)().services;
  const viewMode = (_dashboardContainer$s = dashboardContainer === null || dashboardContainer === void 0 ? void 0 : dashboardContainer.select(state => state.explicitInput.viewMode)) !== null && _dashboardContainer$s !== void 0 ? _dashboardContainer$s : _public2.ViewMode.VIEW;
  const {
    navigateTo,
    getAppUrl
  } = (0, _kibana.useNavigation)();
  const redirectTo = (0, _react.useCallback)(({
    destination,
    id
  }) => {
    if (destination === 'listing') {
      navigateTo({
        deepLinkId: _common.SecurityPageName.dashboards
      });
    }
    if (destination === 'dashboard') {
      navigateTo({
        deepLinkId: _common.SecurityPageName.dashboards,
        path: id ? `${id}/edit` : `/create`
      });
    }
  }, [navigateTo]);
  const landingBreadcrumb = (0, _react.useMemo)(() => [{
    text: _constants.APP_NAME,
    href: getAppUrl({
      deepLinkId: _common.SecurityPageName.landing
    })
  }], [getAppUrl]);
  (0, _react.useEffect)(() => {
    onLoad === null || onLoad === void 0 ? void 0 : onLoad(viewMode);
  }, [onLoad, viewMode]);
  const embedSettings = (0, _react.useMemo)(() => ({
    forceHideFilterBar: true,
    forceShowTopNavMenu: true,
    forceShowQueryInput: false,
    forceShowDatePicker: false
  }), []);
  const {
    showWriteControls
  } = (0, _kibana.useCapabilities)(_public.LEGACY_DASHBOARD_APP_ID);
  return showWriteControls ? /*#__PURE__*/_react.default.createElement(_public.DashboardTopNav, {
    customLeadingBreadCrumbs: landingBreadcrumb,
    dashboardContainer: dashboardContainer,
    forceHideUnifiedSearch: true,
    embedSettings: embedSettings,
    redirectTo: redirectTo,
    showBorderBottom: false,
    setCustomHeaderActionMenu: setHeaderActionMenu,
    showResetChange: false
  }) : null;
};
const DashboardToolBar = /*#__PURE__*/_react.default.memo(DashboardToolBarComponent);
exports.DashboardToolBar = DashboardToolBar;