"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowTimeline = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _use_show_timeline_for_path = require("./use_show_timeline_for_path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useShowTimeline = () => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const getIsTimelineVisible = (0, _use_show_timeline_for_path.useShowTimelineForGivenPath)();
  const showTimeline = (0, _react.useMemo)(() => getIsTimelineVisible(pathname), [pathname, getIsTimelineVisible]);
  return [showTimeline];
};
exports.useShowTimeline = useShowTimeline;