"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBoolean = exports.hasUserCRUDPermission = exports.explainLackOfPermission = exports.canEditRuleWithActions = void 0;
var i18nActions = _interopRequireWildcard(require("../../../detections/pages/detection_engine/rules/translations"));
var _helpers = require("../../../../common/machine_learning/helpers");
var detectionI18n = _interopRequireWildcard(require("../../../detections/pages/detection_engine/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isBoolean = obj => typeof obj === 'boolean';
exports.isBoolean = isBoolean;
const canEditRuleWithActions = (rule, privileges) => {
  var _rule$actions;
  if (rule == null) {
    return true;
  }
  if (((_rule$actions = rule.actions) === null || _rule$actions === void 0 ? void 0 : _rule$actions.length) > 0 && isBoolean(privileges)) {
    return privileges;
  }
  return true;
};

// typed as null not undefined as the initial state for this value is null.
exports.canEditRuleWithActions = canEditRuleWithActions;
const hasUserCRUDPermission = canUserCRUD => canUserCRUD != null ? canUserCRUD : true;
exports.hasUserCRUDPermission = hasUserCRUDPermission;
const explainLackOfPermission = (rule, hasMlPermissions, hasReadActionsPrivileges, canUserCRUD) => {
  if (rule == null) {
    return undefined;
  } else if ((0, _helpers.isMlRule)(rule.type) && !hasMlPermissions) {
    return detectionI18n.ML_RULES_DISABLED_MESSAGE;
  } else if (!canEditRuleWithActions(rule, hasReadActionsPrivileges)) {
    return i18nActions.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES;
  } else if (!hasUserCRUDPermission(canUserCRUD)) {
    return i18nActions.LACK_OF_KIBANA_SECURITY_PRIVILEGES;
  } else {
    return undefined;
  }
};
exports.explainLackOfPermission = explainLackOfPermission;