"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStore = exports.createStoreFactory = exports.createStore = void 0;
var _redux = require("redux");
var _developmentOnly = require("redux-devtools-extension/developmentOnly");
var _reduxObservable = require("redux-observable");
var _rxjs = require("rxjs");
var _reduceReducers = _interopRequireDefault(require("reduce-reducers"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _reducer = require("./grouping/reducer");
var _constants = require("../../../common/constants");
var _telemetry = require("../lib/telemetry");
var _app = require("./app");
var _timeline = require("../../timelines/store/timeline");
var timelineActions = _interopRequireWildcard(require("../../timelines/store/timeline/actions"));
var _inputs = require("./inputs");
var _reducer2 = require("./reducer");
var _epic = require("./epic");
var _model = require("./sourcerer/model");
var _create_sourcerer_data_view = require("../containers/sourcerer/create_sourcerer_data_view");
var _middleware = require("../../resolver/store/middleware");
var _factory = require("../../resolver/data_access_layer/factory");
var _sourcerer = require("./sourcerer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let store = null;
const createStoreFactory = async (coreStart, startPlugins, subPlugins, storage, enableExperimental) => {
  var _startPlugins$timelin, _startPlugins$timelin2, _subPlugins$managemen, _subPlugins$explore$s, _resolverMiddlewareFa;
  let signal = {
    name: null
  };
  try {
    if (coreStart.application.capabilities[_constants.SERVER_APP_ID].show === true) {
      signal = await coreStart.http.fetch(_constants.DETECTION_ENGINE_INDEX_URL, {
        version: '2023-10-31',
        method: 'GET'
      });
    }
  } catch {
    signal = {
      name: null
    };
  }
  const configPatternList = coreStart.uiSettings.get(_constants.DEFAULT_INDEX_KEY);
  let defaultDataView;
  let kibanaDataViews;
  try {
    var _await$startPlugins$s, _startPlugins$spaces;
    // check for/generate default Security Solution Kibana data view
    const sourcererDataViews = await (0, _create_sourcerer_data_view.createSourcererDataView)({
      body: {
        patternList: [...configPatternList, ...(signal.name != null ? [signal.name] : [])]
      },
      dataViewService: startPlugins.data.dataViews,
      dataViewId: `${_constants.DEFAULT_DATA_VIEW_ID}-${(_await$startPlugins$s = await ((_startPlugins$spaces = startPlugins.spaces) === null || _startPlugins$spaces === void 0 ? void 0 : _startPlugins$spaces.getActiveSpace())) === null || _await$startPlugins$s === void 0 ? void 0 : _await$startPlugins$s.id}`
    });
    if (sourcererDataViews === undefined) {
      throw new Error('');
    }
    defaultDataView = {
      ..._model.initDataView,
      ...sourcererDataViews.defaultDataView
    };
    kibanaDataViews = sourcererDataViews.kibanaDataViews.map(dataView => ({
      ..._model.initDataView,
      ...dataView
    }));
  } catch (error) {
    defaultDataView = {
      ..._model.initDataView,
      error
    };
    kibanaDataViews = [];
  }
  const appLibs = {
    kibana: coreStart
  };
  const libs$ = new _rxjs.BehaviorSubject(appLibs);
  const timelineInitialState = {
    timeline: {
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      ...subPlugins.timelines.store.initialState.timeline,
      timelineById: {
        ...subPlugins.timelines.store.initialState.timeline.timelineById
      }
    }
  };
  const dataTableInitialState = {
    dataTable: {
      tableById: {
        /* eslint-disable @typescript-eslint/no-non-null-assertion */
        ...subPlugins.alerts.storageDataTables.tableById,
        ...subPlugins.rules.storageDataTables.tableById,
        ...subPlugins.exceptions.storageDataTables.tableById,
        ...subPlugins.explore.exploreDataTables.hosts.tableById,
        ...subPlugins.explore.exploreDataTables.network.tableById,
        ...subPlugins.explore.exploreDataTables.users.tableById
        /* eslint-enable @typescript-eslint/no-non-null-assertion */
      }
    }
  };

  const groupsInitialState = {
    groups: _reducer.initialGroupingState
  };
  const analyzerInitialState = {
    analyzer: {}
  };
  const timelineReducer = (0, _reduceReducers.default)(timelineInitialState.timeline, (_startPlugins$timelin = (_startPlugins$timelin2 = startPlugins.timelines) === null || _startPlugins$timelin2 === void 0 ? void 0 : _startPlugins$timelin2.getTimelineReducer()) !== null && _startPlugins$timelin !== void 0 ? _startPlugins$timelin : {}, subPlugins.timelines.store.reducer.timeline);
  const initialState = (0, _reducer2.createInitialState)({
    ...subPlugins.explore.store.initialState,
    ...timelineInitialState,
    ...subPlugins.management.store.initialState
  }, {
    defaultDataView,
    kibanaDataViews,
    signalIndexName: signal.name,
    enableExperimental
  }, dataTableInitialState, groupsInitialState, analyzerInitialState);
  const rootReducer = {
    ...subPlugins.explore.store.reducer,
    timeline: timelineReducer,
    ...subPlugins.management.store.reducer
  };
  return createStore(initialState, rootReducer, libs$.pipe((0, _rxjs.pluck)('kibana')), storage, [...((_subPlugins$managemen = subPlugins.management.store.middleware) !== null && _subPlugins$managemen !== void 0 ? _subPlugins$managemen : []), ...((_subPlugins$explore$s = subPlugins.explore.store.middleware) !== null && _subPlugins$explore$s !== void 0 ? _subPlugins$explore$s : []), ...[(_resolverMiddlewareFa = (0, _middleware.resolverMiddlewareFactory)((0, _factory.dataAccessLayerFactory)(coreStart))) !== null && _resolverMiddlewareFa !== void 0 ? _resolverMiddlewareFa : []]]);
};
exports.createStoreFactory = createStoreFactory;
const timelineActionsWithNonserializablePayloads = [timelineActions.updateTimeline.type, timelineActions.addTimeline.type, timelineActions.initializeTimelineSettings.type];
const actionSanitizer = action => {
  if (action.type === _sourcerer.sourcererActions.setDataView.type) {
    return {
      ...action,
      payload: {
        ...action.payload,
        dataView: 'dataView',
        browserFields: 'browserFields',
        indexFields: 'indexFields',
        fields: 'fields'
      }
    };
  } else if (timelineActionsWithNonserializablePayloads.includes(action.type)) {
    const {
      type,
      payload
    } = action;
    if (type === timelineActions.addTimeline.type || type === timelineActions.updateTimeline.type) {
      return {
        ...action,
        payload: {
          ...payload,
          timeline: sanitizeTimelineModel(payload.timeline)
        }
      };
    } else if (type === timelineActions.initializeTimelineSettings.type) {
      return {
        ...action,
        payload: {
          ...payload,
          timeline: sanitizeTimelineModel(payload.timeline)
        }
      };
    }
  }
  return action;
};
const sanitizeDataView = dataView => {
  return {
    ...dataView,
    browserFields: 'browserFields',
    indexFields: 'indexFields',
    fields: 'fields',
    dataView: 'dataView'
  };
};
const sanitizeTimelineModel = timeline => {
  return {
    ...timeline,
    filterManager: 'filterManager',
    footerText: 'footerText',
    loadingText: 'loadingText'
  };
};
const stateSanitizer = state => {
  if (state.sourcerer) {
    return {
      ...state,
      sourcerer: {
        ...state.sourcerer,
        defaultDataView: sanitizeDataView(state.sourcerer.defaultDataView),
        kibanaDataViews: state.sourcerer.kibanaDataViews.map(sanitizeDataView)
      }
    };
  } else {
    return state;
  }
};

/**
 * Factory for Security App's redux store.
 */
const createStore = (state, pluginsReducer, kibana, storage, additionalMiddleware) => {
  const enhancerOptions = {
    name: 'Kibana Security Solution',
    actionsBlacklist: ['USER_MOVED_POINTER', 'USER_SET_RASTER_SIZE'],
    actionSanitizer: actionSanitizer,
    stateSanitizer: stateSanitizer
    // uncomment the following to enable redux action tracing
    // https://github.com/zalmoxisus/redux-devtools-extension/commit/64717bb9b3534ff616d9db56c2be680627c7b09d#diff-182cb140f8a0fd8bc37bbdcdad07bbadb9aebeb2d1b8ed026acd6132f2c88ce8R10
    // trace: true,
    // traceLimit: 100,
  };

  const composeEnhancers = (0, _developmentOnly.composeWithDevTools)(enhancerOptions);
  const middlewareDependencies = {
    kibana$: kibana,
    selectAllTimelineQuery: _inputs.inputsSelectors.globalQueryByIdSelector,
    selectNotesByIdSelector: _app.appSelectors.selectNotesByIdSelector,
    timelineByIdSelector: _timeline.timelineSelectors.timelineByIdSelector,
    timelineTimeRangeSelector: _inputs.inputsSelectors.timelineTimeRangeSelector,
    tableByIdSelector: _securitysolutionDataTable.dataTableSelectors.tableByIdSelector,
    storage
  };
  const epicMiddleware = (0, _reduxObservable.createEpicMiddleware)({
    dependencies: middlewareDependencies
  });
  const middlewareEnhancer = (0, _redux.applyMiddleware)(epicMiddleware, _telemetry.telemetryMiddleware, ...(additionalMiddleware !== null && additionalMiddleware !== void 0 ? additionalMiddleware : []));
  store = (0, _redux.createStore)((0, _reducer2.createReducer)(pluginsReducer), state, composeEnhancers(middlewareEnhancer));
  epicMiddleware.run((0, _epic.createRootEpic)());
  return store;
};
exports.createStore = createStore;
const getStore = () => store;
exports.getStore = getStore;