"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securitySolutionDiscoverReducer = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _actions = require("./actions");
var _model = require("./model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const securitySolutionDiscoverReducer = (0, _typescriptFsaReducers.reducerWithInitialState)(_model.initialDiscoverAppState).case(_actions.updateDiscoverAppState, (state, {
  newState
}) => {
  return {
    ...state,
    app: {
      ...state.app,
      ...newState
    }
  };
}).case(_actions.updateDiscoverInternalState, (state, {
  newState
}) => {
  return {
    ...state,
    internal: newState
  };
}).case(_actions.updateDiscoverSavedSearchState, (state, {
  newState
}) => {
  return {
    ...state,
    savedSearch: newState
  };
});
exports.securitySolutionDiscoverReducer = securitySolutionDiscoverReducer;