"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormFieldMock = exports.kibanaObservable = exports.TestProvidersWithPrivileges = exports.TestProvidersComponent = exports.TestProviders = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _dnd = require("@hello-pangea/dnd");
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _styledComponents = require("styled-components");
var _reactQuery = require("@tanstack/react-query");
var _cellActions = require("@kbn/cell-actions");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _kibana = require("../lib/kibana");
var _upselling_provider = require("../components/upselling_provider");
var _mock_assistant_provider = require("./mock_assistant_provider");
var _console = require("../../management/components/console");
var _store = require("../store");
var _global_state = require("./global_state");
var _kibana_react = require("../lib/kibana/kibana_react.mock");
var _utils = require("./utils");
var _mock_local_storage = require("./mock_local_storage");
var _constants = require("../../../common/constants");
var _user_privileges_context = require("../components/user_privileges/user_privileges_context");
var _discover_in_timeline_provider = require("../components/discover_in_timeline/mocks/discover_in_timeline_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const state = _global_state.mockGlobalState;
const kibanaObservable = new _rxjs.BehaviorSubject((0, _kibana_react.createStartServicesMock)());
exports.kibanaObservable = kibanaObservable;
Object.defineProperty(window, 'localStorage', {
  value: (0, _mock_local_storage.localStorageMock)()
});
window.scrollTo = jest.fn();
const MockKibanaContextProvider = (0, _kibana_react.createKibanaContextProviderMock)();
const {
  storage
} = (0, _mock_local_storage.createSecuritySolutionStorageMock)();

/** A utility for wrapping children in the providers required to run most tests */
const TestProvidersComponent = ({
  children,
  store = (0, _store.createStore)(state, _utils.SUB_PLUGINS_REDUCER, kibanaObservable, storage),
  onDragEnd = jest.fn(),
  cellActions = []
}) => {
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(MockKibanaContextProvider, null, /*#__PURE__*/_react.default.createElement(UpsellingProviderMock, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_styledComponents.ThemeProvider, {
    theme: () => ({
      eui: _uiTheme.euiDarkVars,
      darkMode: true
    })
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_discover_in_timeline_provider.MockDiscoverInTimelineContext, null, /*#__PURE__*/_react.default.createElement(_mock_assistant_provider.MockAssistantProvider, null, /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyoutProvider, null, /*#__PURE__*/_react.default.createElement(_console.ConsoleManager, null, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: () => Promise.resolve(cellActions)
  }, /*#__PURE__*/_react.default.createElement(_dnd.DragDropContext, {
    onDragEnd: onDragEnd
  }, children))))))))))));
};
exports.TestProvidersComponent = TestProvidersComponent;
const UpsellingProviderMock = ({
  children
}) => {
  const upselingService = (0, _kibana.useKibana)().services.upselling;
  return /*#__PURE__*/_react.default.createElement(_upselling_provider.UpsellingProvider, {
    upsellingService: upselingService
  }, children);
};

/**
 * A utility for wrapping children in the providers required to run most tests
 * WITH user privileges provider.
 */
const TestProvidersWithPrivilegesComponent = ({
  children,
  store = (0, _store.createStore)(state, _utils.SUB_PLUGINS_REDUCER, kibanaObservable, storage),
  onDragEnd = jest.fn(),
  cellActions = []
}) => {
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(MockKibanaContextProvider, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_styledComponents.ThemeProvider, {
    theme: () => ({
      eui: _uiTheme.euiDarkVars,
      darkMode: true
    })
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_discover_in_timeline_provider.MockDiscoverInTimelineContext, null, /*#__PURE__*/_react.default.createElement(_mock_assistant_provider.MockAssistantProvider, null, /*#__PURE__*/_react.default.createElement(_user_privileges_context.UserPrivilegesProvider, {
    kibanaCapabilities: {
      siem: {
        show: true,
        crud: true
      },
      [_constants.CASES_FEATURE_ID]: {
        read_cases: true,
        crud_cases: false
      },
      [_constants.ASSISTANT_FEATURE_ID]: {
        'ai-assistant': true
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: () => Promise.resolve(cellActions)
  }, /*#__PURE__*/_react.default.createElement(_dnd.DragDropContext, {
    onDragEnd: onDragEnd
  }, children))))))))));
};
const TestProviders = /*#__PURE__*/_react.default.memo(TestProvidersComponent);
exports.TestProviders = TestProviders;
const TestProvidersWithPrivileges = /*#__PURE__*/_react.default.memo(TestProvidersWithPrivilegesComponent);
exports.TestProvidersWithPrivileges = TestProvidersWithPrivileges;
const useFormFieldMock = options => {
  return {
    path: 'path',
    type: 'type',
    value: 'mockedValue',
    isPristine: false,
    isDirty: false,
    isModified: false,
    isValidating: false,
    isValidated: false,
    isChangingValue: false,
    errors: [],
    isValid: true,
    getErrorsMessages: jest.fn(),
    onChange: jest.fn(),
    setValue: jest.fn(),
    setErrors: jest.fn(),
    clearErrors: jest.fn(),
    validate: jest.fn(),
    reset: jest.fn(),
    __isIncludedInOutput: true,
    __serializeValue: jest.fn(),
    ...options
  };
};
exports.useFormFieldMock = useFormFieldMock;