"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockAssistantProviderComponent = exports.MockAssistantProvider = void 0;
var _coreHttpBrowserMocks = require("@kbn/core-http-browser-mocks");
var _action_type_registry = require("@kbn/triggers-actions-ui-plugin/public/application/action_type_registry.mock");
var _react = _interopRequireDefault(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

window.scrollTo = jest.fn();
window.HTMLElement.prototype.scrollIntoView = jest.fn();

/** A utility for wrapping children in the providers required to run tests */
const MockAssistantProviderComponent = ({
  children
}) => {
  const actionTypeRegistry = _action_type_registry.actionTypeRegistryMock.create();
  const mockHttp = _coreHttpBrowserMocks.httpServiceMock.createStartContract({
    basePath: '/test'
  });
  mockHttp.get.mockResolvedValue([]);
  const mockAssistantAvailability = {
    hasAssistantPrivilege: false,
    hasConnectorsAllPrivilege: true,
    hasConnectorsReadPrivilege: true,
    isAssistantEnabled: true
  };
  return /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantProvider, {
    actionTypeRegistry: actionTypeRegistry,
    assistantAvailability: mockAssistantAvailability,
    augmentMessageCodeBlocks: jest.fn(() => []),
    baseAllow: [],
    baseAllowReplacement: [],
    basePath: 'https://localhost:5601/kbn',
    defaultAllow: [],
    docLinks: {
      ELASTIC_WEBSITE_URL: 'https://www.elastic.co/',
      DOC_LINK_VERSION: 'current'
    },
    defaultAllowReplacement: [],
    getComments: jest.fn(() => []),
    getInitialConversations: jest.fn(() => ({})),
    setConversations: jest.fn(),
    setDefaultAllow: jest.fn(),
    setDefaultAllowReplacement: jest.fn(),
    http: mockHttp
  }, children);
};
exports.MockAssistantProviderComponent = MockAssistantProviderComponent;
MockAssistantProviderComponent.displayName = 'MockAssistantProviderComponent';
const MockAssistantProvider = /*#__PURE__*/_react.default.memo(MockAssistantProviderComponent);
exports.MockAssistantProvider = MockAssistantProvider;