"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRootNavLink = exports.useNavLinks = exports.navLinks$ = exports.formatNavigationLinks = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _links = require("./links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatNavigationLinks = appLinks => appLinks.map(link => {
  var _link$links;
  return {
    id: link.id,
    title: link.title,
    ...(link.categories != null ? {
      categories: link.categories
    } : {}),
    ...(link.description != null ? {
      description: link.description
    } : {}),
    ...(link.sideNavDisabled === true ? {
      disabled: true
    } : {}),
    ...(link.landingIcon != null ? {
      landingIcon: link.landingIcon
    } : {}),
    ...(link.landingImage != null ? {
      landingImage: link.landingImage
    } : {}),
    ...(link.sideNavIcon != null ? {
      sideNavIcon: link.sideNavIcon
    } : {}),
    ...(link.skipUrlState != null ? {
      skipUrlState: link.skipUrlState
    } : {}),
    ...(link.isBeta != null ? {
      isBeta: link.isBeta
    } : {}),
    ...(link.betaOptions != null ? {
      betaOptions: link.betaOptions
    } : {}),
    ...(((_link$links = link.links) === null || _link$links === void 0 ? void 0 : _link$links.length) && {
      links: formatNavigationLinks(link.links)
    })
  };
});

/**
 * Navigation links observable based on Security AppLinks,
 * It is used to generate the side navigation items
 */
exports.formatNavigationLinks = formatNavigationLinks;
const navLinks$ = _links.appLinks$.pipe((0, _rxjs.map)(formatNavigationLinks));
exports.navLinks$ = navLinks$;
const useNavLinks = () => {
  return (0, _useObservable.default)(navLinks$, []);
};
exports.useNavLinks = useNavLinks;
const useRootNavLink = linkId => {
  return useNavLinks().find(({
    id
  }) => id === linkId);
};
exports.useRootNavLink = useRootNavLink;