"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertsGroupingToggledEvent = exports.alertsGroupingTakeActionEvent = exports.alertsGroupingChangedEvent = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsGroupingToggledEvent = {
  eventType: _constants.TelemetryEventTypes.AlertsGroupingToggled,
  schema: {
    isOpen: {
      type: 'boolean',
      _meta: {
        description: 'on or off',
        optional: false
      }
    },
    tableId: {
      type: 'text',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    groupNumber: {
      type: 'integer',
      _meta: {
        description: 'Group number',
        optional: false
      }
    }
  }
};
exports.alertsGroupingToggledEvent = alertsGroupingToggledEvent;
const alertsGroupingChangedEvent = {
  eventType: _constants.TelemetryEventTypes.AlertsGroupingChanged,
  schema: {
    tableId: {
      type: 'keyword',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    groupByField: {
      type: 'keyword',
      _meta: {
        description: 'Selected field',
        optional: false
      }
    }
  }
};
exports.alertsGroupingChangedEvent = alertsGroupingChangedEvent;
const alertsGroupingTakeActionEvent = {
  eventType: _constants.TelemetryEventTypes.AlertsGroupingTakeAction,
  schema: {
    tableId: {
      type: 'keyword',
      _meta: {
        description: 'Table ID',
        optional: false
      }
    },
    groupNumber: {
      type: 'integer',
      _meta: {
        description: 'Group number',
        optional: false
      }
    },
    status: {
      type: 'keyword',
      _meta: {
        description: 'Alert status',
        optional: false
      }
    },
    groupByField: {
      type: 'keyword',
      _meta: {
        description: 'Selected field',
        optional: false
      }
    }
  }
};
exports.alertsGroupingTakeActionEvent = alertsGroupingTakeActionEvent;