"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Clipboard = exports.COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../hooks/use_app_toasts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = 'copy-to-clipboard';
exports.COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME;
const Clipboard = ({
  children,
  content,
  isHoverAction,
  onCopy,
  titleSummary,
  toastLifeTimeMs
}) => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const onClick = event => {
    event.preventDefault();
    event.stopPropagation();
    const isSuccess = (0, _copyToClipboard.default)(`${content}`, {
      debug: true
    });
    if (onCopy != null) {
      onCopy({
        content,
        isSuccess
      });
    }
    if (isSuccess) {
      addSuccess(`${i18n.COPIED} ${titleSummary} ${i18n.TO_THE_CLIPBOARD}`, {
        toastLifeTimeMs
      });
    }
  };
  const className = (0, _classnames.default)(COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME, {
    // eslint-disable-next-line @typescript-eslint/naming-convention
    securitySolution__hoverActionButton: isHoverAction
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.COPY_TO_THE_CLIPBOARD,
    className: className,
    "data-test-subj": "clipboard",
    iconType: "copyClipboard",
    onClick: onClick
  }, children);
};
exports.Clipboard = Clipboard;