"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaServices = exports.onFilterAdded = exports.getLinkColumnDefinition = exports.EmptyComponent = exports.COLUMNS_WITH_LINKS = void 0;
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../timelines/components/timeline/body/renderers/constants");
var _constants2 = require("../../../../common/cti/constants");
var _ip = require("../../../explore/network/components/ip");
var _helpers = require("../../../explore/network/components/port/helpers");
var _kibana = require("../kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COLUMNS_WITH_LINKS = [{
  columnId: _constants.HOST_NAME_FIELD_NAME,
  label: i18n.VIEW_HOST_SUMMARY
}, {
  columnId: 'source.ip',
  fieldType: _ip.IP_FIELD_TYPE,
  label: i18n.EXPAND_IP_DETAILS
}, {
  columnId: 'destination.ip',
  fieldType: _ip.IP_FIELD_TYPE,
  label: i18n.EXPAND_IP_DETAILS
}, {
  columnId: 'signal.rule.name',
  label: i18n.VIEW_RULE_DETAILS,
  linkField: 'signal.rule.id'
}, ..._helpers.PORT_NAMES.map(p => ({
  columnId: p,
  label: i18n.VIEW_PORT_DETAILS
})), {
  columnId: _constants.RULE_REFERENCE_FIELD_NAME,
  label: i18n.VIEW_RULE_REFERENCE
}, {
  columnId: _constants.REFERENCE_URL_FIELD_NAME,
  label: i18n.VIEW_RULE_REFERENCE
}, {
  columnId: _constants.EVENT_URL_FIELD_NAME,
  label: i18n.VIEW_EVENT_REFERENCE
}, {
  columnId: _constants2.INDICATOR_REFERENCE,
  label: i18n.VIEW_INDICATOR_REFERENCE
}, {
  columnId: _constants.USER_NAME_FIELD_NAME,
  label: i18n.VIEW_USER_SUMMARY
}];
exports.COLUMNS_WITH_LINKS = COLUMNS_WITH_LINKS;
const getLinkColumnDefinition = (columnIdToFind, fieldType, linkField) => COLUMNS_WITH_LINKS.find(column => {
  if (column.columnId === columnIdToFind) {
    return true;
  } else if (column.fieldType && fieldType === column.fieldType && (linkField !== undefined || column.linkField !== undefined)) {
    return true;
  } else {
    return false;
  }
});

/** a noop required by the filter in / out buttons */
exports.getLinkColumnDefinition = getLinkColumnDefinition;
const onFilterAdded = () => {};

/** a hook to eliminate the verbose boilerplate required to use common services */
exports.onFilterAdded = onFilterAdded;
const useKibanaServices = () => {
  const {
    timelines,
    data: {
      query: {
        filterManager
      }
    }
  } = (0, _kibana.useKibana)().services;
  return {
    timelines,
    filterManager
  };
};
exports.useKibanaServices = useKibanaServices;
const EmptyComponent = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
exports.EmptyComponent = EmptyComponent;