"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFieldSpec = void 0;
var _react = require("react");
var _selectors = require("../store/sourcerer/selectors");
var _use_selector = require("./use_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Calls it from the module scope due to non memoized selectors https://github.com/elastic/kibana/issues/159315
const selectedDataviewSelector = (0, _selectors.getSelectedDataviewSelector)();
const useGetFieldSpec = scopeId => {
  const dataView = (0, _use_selector.useDeepEqualSelector)(state => selectedDataviewSelector(state, scopeId));
  return (0, _react.useCallback)(fieldName => {
    const fields = dataView === null || dataView === void 0 ? void 0 : dataView.fields;
    return fields && fields[fieldName];
  }, [dataView === null || dataView === void 0 ? void 0 : dataView.fields]);
};
exports.useGetFieldSpec = useGetFieldSpec;