"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventEnrichmentComplete = exports.getEventEnrichment = void 0;
var _operators = require("rxjs/operators");
var _common = require("@kbn/data-plugin/common");
var _cti = require("../../../../../common/search_strategy/security_solution/cti");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEventEnrichment = ({
  data,
  defaultIndex,
  eventFields,
  filterQuery,
  timerange,
  signal
}) => data.search.search({
  defaultIndex,
  eventFields,
  factoryQueryType: _cti.CtiQueries.eventEnrichment,
  filterQuery,
  timerange
}, {
  strategy: 'securitySolutionSearchStrategy',
  abortSignal: signal
});
exports.getEventEnrichment = getEventEnrichment;
const getEventEnrichmentComplete = props => getEventEnrichment(props).pipe((0, _operators.filter)(response => !(0, _common.isRunningResponse)(response)));
exports.getEventEnrichmentComplete = getEventEnrichmentComplete;