"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRedirectToDashboardFromLens = void 0;
var _react = require("react");
var _common = require("../../../../common");
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRedirectToDashboardFromLens = ({
  getSecuritySolutionUrl
}) => {
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  const dashboardListingUrl = (0, _react.useMemo)(() => `${getSecuritySolutionUrl({
    deepLinkId: _common.SecurityPageName.dashboards
  })}`, [getSecuritySolutionUrl]);
  const getEditOrCreateDashboardPath = (0, _react.useCallback)(id => id != null && id !== 'new' ? `${id}/edit` : `/create`, []);
  const getEditOrCreateDashboardUrl = (0, _react.useCallback)(id => `${getSecuritySolutionUrl({
    deepLinkId: _common.SecurityPageName.dashboards,
    path: getEditOrCreateDashboardPath(id)
  })}`, [getEditOrCreateDashboardPath, getSecuritySolutionUrl]);
  const redirectTo = (0, _react.useCallback)(props => {
    if (props.destination === 'listing') {
      navigateTo({
        url: dashboardListingUrl
      });
    }
    if (props.destination === 'dashboard') {
      navigateTo({
        url: getEditOrCreateDashboardUrl(props.id)
      });
    }
  }, [dashboardListingUrl, getEditOrCreateDashboardUrl, navigateTo]);
  return {
    redirectTo,
    getEditOrCreateDashboardPath,
    getEditOrCreateDashboardUrl,
    dashboardListingUrl
  };
};
exports.useRedirectToDashboardFromLens = useRedirectToDashboardFromLens;