"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToExistingCase = void 0;
var _react = require("react");
var _common = require("@kbn/cases-plugin/common");
var _common2 = require("../../../../common");
var _kibana = require("../../lib/kibana");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddToExistingCase = ({
  onAddToCaseClicked,
  lensAttributes,
  timeRange
}) => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const userCasesPermissions = cases.helpers.canUseCases([_common2.APP_ID]);
  const attachments = (0, _react.useMemo)(() => {
    return [{
      persistableStateAttachmentState: {
        attributes: lensAttributes,
        timeRange
      },
      persistableStateAttachmentTypeId: _common.LENS_ATTACHMENT_TYPE,
      type: _common.AttachmentType.persistableState
    }];
  }, [lensAttributes, timeRange]);
  const selectCaseModal = cases.hooks.useCasesAddToExistingCaseModal({
    onClose: onAddToCaseClicked,
    successToaster: {
      title: _translations.ADD_TO_CASE_SUCCESS
    }
  });
  const onAddToExistingCaseClicked = (0, _react.useCallback)(() => {
    if (onAddToCaseClicked) {
      onAddToCaseClicked();
    }
    selectCaseModal.open({
      getAttachments: () => attachments
    });
  }, [attachments, onAddToCaseClicked, selectCaseModal]);
  return {
    onAddToExistingCaseClicked,
    disabled: lensAttributes == null || timeRange == null || !userCasesPermissions.create || !userCasesPermissions.read
  };
};
exports.useAddToExistingCase = useAddToExistingCase;