"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../store/inputs/constants");
var _kibana_react = require("../../lib/kibana/kibana_react");
var _modal = require("../inspect/modal");
var _use_inspect = require("../inspect/use_inspect");
var _use_lens_attributes = require("./use_lens_attributes");
var _use_add_to_existing_case = require("./use_add_to_existing_case");
var _use_add_to_new_case = require("./use_add_to_new_case");
var _use_save_to_library = require("./use_save_to_library");
var _translations = require("./translations");
var _utils = require("./utils");
var _model = require("../../store/sourcerer/model");
var _use_app_toasts = require("../../hooks/use_app_toasts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Wrapper = _styledComponents.default.div`
  &.viz-actions {
    position: absolute;
    top: 0;
    right: 0;
    z-index: 1;
  }
  &.histogram-viz-actions {
    padding: ${({
  theme
}) => theme.eui.euiSizeS};
  }
`;
const VisualizationActionsComponent = ({
  applyGlobalQueriesAndFilters = true,
  className,
  extraActions,
  extraOptions,
  getLensAttributes,
  inputId = _constants.InputsModelId.global,
  inspectIndex = 0,
  isInspectButtonDisabled,
  isMultipleQuery,
  lensAttributes,
  onCloseInspect,
  queryId,
  timerange,
  title: inspectTitle,
  scopeId = _model.SourcererScopeName.default,
  stackByField,
  withDefaultActions = true
}) => {
  const {
    lens
  } = (0, _kibana_react.useKibana)().services;
  const {
    canUseEditor,
    navigateToPrefilledEditor,
    SaveModalComponent
  } = lens;
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const [isInspectModalOpen, setIsInspectModalOpen] = (0, _react.useState)(false);
  const [isSaveModalVisible, setIsSaveModalVisible] = (0, _react.useState)(false);
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const onSave = (0, _react.useCallback)(() => {
    setIsSaveModalVisible(false);
    addSuccess(_translations.ADDED_TO_LIBRARY);
  }, [addSuccess]);
  const onClose = (0, _react.useCallback)(() => {
    setIsSaveModalVisible(false);
  }, []);
  const hasPermission = canUseEditor();
  const onButtonClick = (0, _react.useCallback)(() => {
    setPopover(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = () => {
    setPopover(false);
  };
  const attributes = (0, _use_lens_attributes.useLensAttributes)({
    applyGlobalQueriesAndFilters,
    extraOptions,
    getLensAttributes,
    lensAttributes,
    scopeId,
    stackByField,
    title: ''
  });
  const dataTestSubj = `stat-${queryId}`;
  const {
    disabled: isAddToExistingCaseDisabled,
    onAddToExistingCaseClicked
  } = (0, _use_add_to_existing_case.useAddToExistingCase)({
    onAddToCaseClicked: closePopover,
    lensAttributes: attributes,
    timeRange: timerange
  });
  const {
    onAddToNewCaseClicked,
    disabled: isAddToNewCaseDisabled
  } = (0, _use_add_to_new_case.useAddToNewCase)({
    onClick: closePopover,
    timeRange: timerange,
    lensAttributes: attributes
  });
  const onOpenInLens = (0, _react.useCallback)(() => {
    closePopover();
    if (!timerange || !attributes) {
      return;
    }
    navigateToPrefilledEditor({
      id: '',
      timeRange: timerange,
      attributes
    }, {
      openInNewTab: true
    });
  }, [attributes, navigateToPrefilledEditor, timerange]);
  const {
    openSaveVisualizationFlyout,
    disableVisualizations
  } = (0, _use_save_to_library.useSaveToLibrary)({
    attributes
  });
  const onOpenInspectModal = (0, _react.useCallback)(() => {
    closePopover();
    setIsInspectModalOpen(true);
  }, []);
  const onCloseInspectModal = (0, _react.useCallback)(() => {
    setIsInspectModalOpen(false);
    if (onCloseInspect) {
      onCloseInspect();
    }
  }, [onCloseInspect]);
  const {
    additionalRequests,
    additionalResponses,
    handleClick: handleInspectButtonClick,
    handleCloseModal: handleCloseInspectModal,
    isButtonDisabled: disableInspectButton,
    request,
    response
  } = (0, _use_inspect.useInspect)({
    inputId,
    inspectIndex,
    isDisabled: isInspectButtonDisabled,
    multiple: isMultipleQuery,
    onCloseInspect: onCloseInspectModal,
    onClick: onOpenInspectModal,
    queryId
  });
  const items = (0, _react.useMemo)(() => {
    var _extraActions$map;
    const context = {};
    const extraActionsItems = (_extraActions$map = extraActions === null || extraActions === void 0 ? void 0 : extraActions.map(item => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        icon: item === null || item === void 0 ? void 0 : item.getIconType(context),
        key: item.id,
        onClick: () => item.execute(context),
        "data-test-subj": `viz-actions-${item.id}`
      }, item.getDisplayName(context));
    })) !== null && _extraActions$map !== void 0 ? _extraActions$map : [];
    return [...(extraActionsItems ? extraActionsItems : []), ...(withDefaultActions ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "inspect",
      key: "visualizationActionsInspect",
      onClick: handleInspectButtonClick,
      disabled: disableInspectButton,
      "data-test-subj": "viz-actions-inspect"
    }, _translations.INSPECT), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      disabled: isAddToNewCaseDisabled,
      icon: "plusInCircle",
      key: "visualizationActionsAddToNewCase",
      onClick: onAddToNewCaseClicked,
      "data-test-subj": "viz-actions-add-to-new-case"
    }, _translations.ADD_TO_NEW_CASE), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      disabled: isAddToExistingCaseDisabled,
      "data-test-subj": "viz-actions-add-to-existing-case",
      icon: "plusInCircle",
      key: "visualizationActionsAddToExistingCase",
      onClick: onAddToExistingCaseClicked
    }, _translations.ADD_TO_EXISTING_CASE), ...(hasPermission ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "visArea",
      key: "visualizationActionsSaveVisualization",
      "data-test-subj": "viz-actions-save-visualization",
      disabled: disableVisualizations,
      onClick: openSaveVisualizationFlyout
    }, _translations.ADDED_TO_LIBRARY)] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "visArea",
      key: "visualizationActionsOpenInLens",
      "data-test-subj": "viz-actions-open-in-lens",
      disabled: disableVisualizations,
      onClick: onOpenInLens
    }, _translations.OPEN_IN_LENS)] : [])];
  }, [hasPermission, disableInspectButton, disableVisualizations, extraActions, handleInspectButtonClick, isAddToExistingCaseDisabled, isAddToNewCaseDisabled, onAddToExistingCaseClicked, onAddToNewCaseClicked, onOpenInLens, openSaveVisualizationFlyout, withDefaultActions]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.MORE_ACTIONS,
    className: _utils.VISUALIZATION_ACTIONS_BUTTON_CLASS,
    "data-test-subj": dataTestSubj,
    iconType: "boxesHorizontal",
    onClick: onButtonClick
  }), [dataTestSubj, onButtonClick]);
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    className: className
  }, items.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    panelClassName: "withHoverActions__popover",
    "data-test-subj": "viz-actions-popover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "viz-actions-panel",
    size: "s",
    items: items
  })), isInspectModalOpen && request !== null && response !== null && /*#__PURE__*/_react.default.createElement(_modal.ModalInspectQuery, {
    additionalRequests: additionalRequests,
    additionalResponses: additionalResponses,
    closeModal: handleCloseInspectModal,
    inputId: inputId,
    request: request,
    response: response,
    title: inspectTitle
  }), isSaveModalVisible && hasPermission && /*#__PURE__*/_react.default.createElement(SaveModalComponent, {
    initialInput: attributes,
    onSave: onSave,
    onClose: onClose
  }));
};
VisualizationActionsComponent.displayName = 'VisualizationActionsComponent';
const VisualizationActions = /*#__PURE__*/_react.default.memo(VisualizationActionsComponent);
exports.VisualizationActions = VisualizationActions;