"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersAvatarsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _userProfileComponents = require("@kbn/user-profile-components");
var _translations = require("./translations");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays users avatars
 */
const UsersAvatarsPanel = /*#__PURE__*/(0, _react.memo)(({
  userProfiles,
  maxVisibleAvatars
}) => {
  if (maxVisibleAvatars && userProfiles.length > maxVisibleAvatars) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: userProfiles.map(user => {
        var _user$user$email;
        return /*#__PURE__*/_react.default.createElement("div", null, user ? (_user$user$email = user.user.email) !== null && _user$user$email !== void 0 ? _user$user$email : user.user.username : _translations.UNKNOWN_USER_PROFILE_NAME);
      }),
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "data-test-subj": _test_ids.USERS_AVATARS_COUNT_BADGE_TEST_ID,
      color: "subdued"
    }, userProfiles.length));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": _test_ids.USERS_AVATARS_PANEL_TEST_ID,
    alignItems: "center",
    direction: "row",
    gutterSize: "xs"
  }, userProfiles.map((user, index) => {
    var _user$user$username;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
      "data-test-subj": (0, _test_ids.USER_AVATAR_ITEM_TEST_ID)((_user$user$username = user === null || user === void 0 ? void 0 : user.user.username) !== null && _user$user$username !== void 0 ? _user$user$username : `Unknown-${index}`),
      user: user === null || user === void 0 ? void 0 : user.user,
      avatar: user === null || user === void 0 ? void 0 : user.data.avatar,
      size: 's'
    }));
  }));
});
exports.UsersAvatarsPanel = UsersAvatarsPanel;
UsersAvatarsPanel.displayName = 'UsersAvatarsPanel';