"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetCurrentUserProfile = exports.getCurrentUserProfile = void 0;
var _reactQuery = require("@tanstack/react-query");
var _translations = require("./translations");
var _kibana = require("../../lib/kibana");
var _use_app_toasts = require("../../hooks/use_app_toasts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCurrentUserProfile = async ({
  security
}) => {
  return security.userProfiles.getCurrent({
    dataPath: 'avatar'
  });
};

/**
 * Fetches current user profile using `userProfiles` service via `security.userProfiles.getCurrent()`
 *
 * NOTE: There is a similar hook `useCurrentUser` which fetches current authenticated user via `security.authc.getCurrentUser()`
 */
exports.getCurrentUserProfile = getCurrentUserProfile;
const useGetCurrentUserProfile = () => {
  const {
    security
  } = (0, _kibana.useKibana)().services;
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _reactQuery.useQuery)(['useGetCurrentUserProfile'], async () => {
    return getCurrentUserProfile({
      security
    });
  }, {
    retry: false,
    staleTime: Infinity,
    onError: e => {
      addError(e, {
        title: _translations.CURRENT_USER_PROFILE_FAILURE
      });
    }
  });
};
exports.useGetCurrentUserProfile = useGetCurrentUserProfile;