"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorToToaster = exports.displaySuccessToast = exports.displayErrorToast = void 0;
var _uuid = require("uuid");
var _fp = require("lodash/fp");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _errors = require("./errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays an error toast for the provided title and message
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 * @param errorTitle Title of error to display in toaster and modal
 * @param errorMessages Message to display in error modal when clicked
 * @param dispatchToaster provided by useStateToaster()
 */
const displayErrorToast = (errorTitle, errorMessages, dispatchToaster, id = (0, _uuid.v4)()) => {
  const toast = {
    id,
    title: errorTitle,
    color: 'danger',
    iconType: 'error',
    errors: errorMessages
  };
  dispatchToaster({
    type: 'addToaster',
    toast
  });
};

/**
 * Displays a success toast for the provided title and message
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 * @param title success message to display in toaster and modal
 * @param dispatchToaster provided by useStateToaster()
 */
exports.displayErrorToast = displayErrorToast;
const displaySuccessToast = (title, dispatchToaster, id = (0, _uuid.v4)()) => {
  const toast = {
    id,
    title,
    color: 'success',
    iconType: 'check'
  };
  dispatchToaster({
    type: 'addToaster',
    toast
  });
};
exports.displaySuccessToast = displaySuccessToast;
/**
 * Displays an error toast with messages parsed from the error.
 *
 * This has shortcomings and bugs compared to using the use_app_toasts because it takes naive guesses at the
 * underlying data structure and does not display much about the error. This is not compatible with bsearch (async search)
 * and sometimes can display to the user blank messages.
 *
 * The use_app_toasts has more feature rich logic and uses the Kibana toaster system to figure out which type of
 * error you have in a more robust way then this function does and supersedes this function.
 *
 * @deprecated Use x-pack/plugins/security_solution/public/common/hooks/use_app_toasts.ts instead
 * @param title error message to display in toaster and modal
 * @param error the error from which messages will be parsed
 * @param dispatchToaster provided by useStateToaster()
 */
const errorToToaster = ({
  id = (0, _uuid.v4)(),
  title,
  error,
  color = 'danger',
  iconType = 'error',
  dispatchToaster
}) => {
  let toast;
  if ((0, _errors.isToasterError)(error)) {
    toast = {
      id,
      title,
      color,
      iconType,
      errors: error.messages
    };
  } else if ((0, _securitysolutionTGrid.isAppError)(error)) {
    toast = {
      id,
      title,
      color,
      iconType,
      errors: [error.body.message]
    };
  } else if ((0, _fp.isError)(error)) {
    toast = {
      id,
      title,
      color,
      iconType,
      errors: [error.message]
    };
  } else {
    toast = {
      id,
      title,
      color,
      iconType,
      errors: ['Network Error']
    };
  }
  dispatchToaster({
    type: 'addToaster',
    toast
  });
};
exports.errorToToaster = errorToToaster;