"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = void 0;
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reducer = () => (state, action) => {
  switch (action.type) {
    case 'setEntries':
      {
        const isAndLogicIncluded = action.entries.filter(({
          entries
        }) => entries.length > 1).length > 0;
        const returnState = {
          ...state,
          andLogicIncluded: isAndLogicIncluded,
          entries: action.entries
        };
        return returnState;
      }
    case 'setDefault':
      {
        return {
          ...state,
          ...action.initialState,
          entries: [{
            ...action.lastEntry,
            entries: [(0, _helpers.getDefaultEmptyEntry)()]
          }]
        };
      }
    default:
      return state;
  }
};
exports.reducer = reducer;