"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcererCallout = exports.SaveButtons = exports.AlertsCheckbox = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourcererCallout = /*#__PURE__*/_react.default.memo(({
  isOnlyDetectionAlerts,
  title
}) => isOnlyDetectionAlerts ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  "data-test-subj": "sourcerer-callout",
  iconType: "iInCircle",
  size: "s",
  title: title
}) : null);
exports.SourcererCallout = SourcererCallout;
SourcererCallout.displayName = 'SourcererCallout';
const AlertsCheckbox = /*#__PURE__*/_react.default.memo(({
  onChange,
  checked,
  isShow
}) => isShow ? /*#__PURE__*/_react.default.createElement(_helpers.StyledFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
  checked: checked,
  "data-test-subj": "sourcerer-alert-only-checkbox",
  id: "sourcerer-alert-only-checkbox",
  label: i18n.ALERTS_CHECKBOX_LABEL,
  onChange: onChange
})) : null);
exports.AlertsCheckbox = AlertsCheckbox;
AlertsCheckbox.displayName = 'AlertsCheckbox';
const SaveButtons = /*#__PURE__*/_react.default.memo(({
  disableSave,
  isShow,
  onReset,
  onSave
}) => isShow ? /*#__PURE__*/_react.default.createElement(_helpers.StyledFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "flexEnd"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_helpers.ResetButton, {
  "aria-label": i18n.INDEX_PATTERNS_RESET,
  "data-test-subj": "sourcerer-reset",
  flush: "left",
  onClick: onReset,
  title: i18n.INDEX_PATTERNS_RESET
}, i18n.INDEX_PATTERNS_RESET)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  onClick: onSave,
  disabled: disableSave,
  "data-test-subj": "sourcerer-save",
  fill: true,
  fullWidth: true,
  size: "s"
}, i18n.SAVE_INDEX_PATTERNS)))) : null);
exports.SaveButtons = SaveButtons;
SaveButtons.displayName = 'SaveButtons';