"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTooltipContent = exports.getPatternListWithoutSignals = exports.getDataViewSelectOptions = exports.StyledFormRow = exports.StyledButtonEmpty = exports.StyledBadge = exports.ResetButton = exports.PopoverContent = exports.FormRow = exports.Blockquote = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _uiTheme = require("@kbn/ui-theme");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  display: ${({
  $expandAdvancedOptions
}) => $expandAdvancedOptions ? 'flex' : 'none'};
  max-width: none;
`;
exports.FormRow = FormRow;
const StyledFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  max-width: none;
`;
exports.StyledFormRow = StyledFormRow;
const StyledButtonEmpty = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  &:enabled:focus,
  &:focus {
    background-color: transparent;
  }
`;
exports.StyledButtonEmpty = StyledButtonEmpty;
const ResetButton = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  width: fit-content;
  &:enabled:focus,
  &:focus {
    background-color: transparent;
  }
`;
exports.ResetButton = ResetButton;
const PopoverContent = _styledComponents.default.div`
  width: 600px;
`;
exports.PopoverContent = PopoverContent;
const StyledBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: ${_uiTheme.euiThemeVars.euiSizeXS};
  &,
  .euiBadge__text {
    cursor: pointer;
  }
`;
exports.StyledBadge = StyledBadge;
const Blockquote = _styledComponents.default.span`
  ${({
  theme
}) => (0, _styledComponents.css)`
    display: block;
    border-color: ${theme.eui.euiColorDarkShade};
    border-left: ${theme.eui.euiBorderThick};
    margin: ${theme.eui.euiSizeS} 0 ${theme.eui.euiSizeS} ${theme.eui.euiSizeS};
    padding: ${theme.eui.euiSizeS};
  `}
`;
exports.Blockquote = Blockquote;
const getDataViewSelectOptions = ({
  dataViewId,
  defaultDataViewId,
  isModified,
  isOnlyDetectionAlerts,
  kibanaDataViews
}) => isOnlyDetectionAlerts ? [{
  inputDisplay: /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "security-alerts-option-super"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSecurity",
    size: "s"
  }), " ", i18n.SIEM_SECURITY_DATA_VIEW_LABEL, /*#__PURE__*/_react.default.createElement(StyledBadge, {
    "data-test-subj": "security-alerts-option-badge"
  }, i18n.ALERTS_BADGE_TITLE)),
  value: defaultDataViewId
}] : kibanaDataViews.map(({
  title,
  id
}) => ({
  inputDisplay: id === defaultDataViewId ? /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "security-option-super"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSecurity",
    size: "s"
  }), " ", i18n.SECURITY_DEFAULT_DATA_VIEW_LABEL, isModified && id === dataViewId && /*#__PURE__*/_react.default.createElement(StyledBadge, {
    "data-test-subj": "security-modified-option-badge"
  }, i18n.MODIFIED_BADGE_TITLE)) : /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "dataView-option-super"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoKibana",
    size: "s"
  }), " ", title, isModified && id === dataViewId && /*#__PURE__*/_react.default.createElement(StyledBadge, {
    "data-test-subj": "security-modified-option-badge"
  }, i18n.MODIFIED_BADGE_TITLE)),
  value: id
}));
exports.getDataViewSelectOptions = getDataViewSelectOptions;
const getTooltipContent = ({
  isOnlyDetectionAlerts,
  isPopoverOpen,
  selectedPatterns,
  signalIndexName
}) => {
  if (isPopoverOpen || isOnlyDetectionAlerts && !signalIndexName) {
    return null;
  }
  return (isOnlyDetectionAlerts ? [signalIndexName] : selectedPatterns).join(', ');
};
exports.getTooltipContent = getTooltipContent;
const getPatternListWithoutSignals = (patternList, signalIndexName) => patternList.filter(p => p !== signalIndexName);
exports.getPatternListWithoutSignals = getPatternListWithoutSignals;