"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadConnectors = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("@kbn/triggers-actions-ui-plugin/public/common/constants");
var i18n = _interopRequireWildcard(require("../translations"));
var _kibana = require("../../../lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to load all connectors for a given action type.
 * @param actionTypeId
 * @param toasts
 */
const useLoadConnectors = ({
  actionTypeId,
  toasts
}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)(['load-connectors', actionTypeId], async () => {
    const queryResult = await (0, _constants.loadAllActions)({
      http
    });
    const filteredData = queryResult.filter(connector => !connector.isMissingSecrets && connector.actionTypeId === actionTypeId);
    return filteredData;
  }, {
    retry: false,
    keepPreviousData: true,
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts === null || toasts === void 0 ? void 0 : toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: i18n.LOAD_CONNECTORS_ERROR_MESSAGE
        });
      }
    }
  });
};
exports.useLoadConnectors = useLoadConnectors;