"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsFeed = void 0;
var _react = _interopRequireDefault(require("react"));
var _loading_placeholders = require("../../../overview/components/loading_placeholders");
var _translations = require("../../../overview/pages/translations");
var _sidebar_header = require("../sidebar_header");
var _no_news = require("./no_news");
var _post = require("./post");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOW_PLACEHOLDERS = 5;
const LINES_PER_LOADING_PLACEHOLDER = 4;
const NewsFeedComponent = ({
  news
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: _translations.NEWS_FEED_TITLE
}), news == null ? /*#__PURE__*/_react.default.createElement(_loading_placeholders.LoadingPlaceholders, {
  lines: LINES_PER_LOADING_PLACEHOLDER,
  placeholders: SHOW_PLACEHOLDERS
}) : news.length === 0 ? /*#__PURE__*/_react.default.createElement(_no_news.NoNews, null) : news.map(n => /*#__PURE__*/_react.default.createElement(_post.Post, {
  key: n.hash,
  newsItem: n
})));
NewsFeedComponent.displayName = 'NewsFeedComponent';
const NewsFeed = /*#__PURE__*/_react.default.memo(NewsFeedComponent);
exports.NewsFeed = NewsFeed;