"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScoreComponent = exports.Score = void 0;
var _react = _interopRequireDefault(require("react"));
var _cell_actions = require("../../cell_actions");
var _page = require("../../page");
var _score_health = require("./score_health");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ScoreComponent = ({
  index = 0,
  score
}) => {
  const scoreString = (0, _score_health.getScoreString)(score.severity);
  return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    mode: _cell_actions.CellActionsMode.HOVER_DOWN,
    data: {
      value: score.entityValue,
      field: score.entityName
    },
    triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    visibleCellActions: 5
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ',', /*#__PURE__*/_react.default.createElement(_page.Spacer, null)), scoreString));
};
exports.ScoreComponent = ScoreComponent;
ScoreComponent.displayName = 'ScoreComponent';
const Score = /*#__PURE__*/_react.default.memo(ScoreComponent);
exports.Score = Score;
Score.displayName = 'Score';